/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.handlers;

import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.handlers.MixedHandler;
import dev.micalobia.fullslabs.handlers.MixedHandlers;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public sealed interface MixedContext {
    public static final Supplier<RuntimeException> MISSING_BE = () -> new RuntimeException("Missing mixed slab block entity!");

    public BlockState mixedState();

    public Optional<MixedSlabBlockEntity> blockEntity();

    public boolean replaceBlock(Block var1);

    public Sided sided(boolean var1);

    default public MixedContext requireBlockEntity() {
        if (this.blockEntity().isEmpty()) {
            throw MISSING_BE.get();
        }
        return this;
    }

    default public MixedSlabBlockEntity blockEntityOrThrow() {
        return this.blockEntity().orElseThrow(MISSING_BE);
    }

    public static Sided create(BlockGetter world, BlockPos pos, boolean towards) {
        return MixedContext.create(world, pos).sided(towards);
    }

    public static Sideless create(BlockGetter world, BlockPos pos) {
        Optional<MixedSlabBlockEntity> optionalEntity;
        MixedSlabBlock block = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        BlockState state = world.getBlockState(pos);
        if (!state.is((Block)block)) {
            throw new IllegalArgumentException("This block isn't a mixed slab!");
        }
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof MixedSlabBlockEntity)) {
            optionalEntity = Optional.empty();
        } else {
            MixedSlabBlockEntity mixed = (MixedSlabBlockEntity)entity;
            optionalEntity = Optional.of(mixed);
        }
        return new Sideless(state, optionalEntity);
    }

    public record Sideless(BlockState mixedState, Optional<MixedSlabBlockEntity> blockEntity) implements MixedContext
    {
        @Override
        public boolean replaceBlock(Block block) {
            return false;
        }

        @Override
        public Sided sided(boolean towards) {
            MixedSlabBlock.MixedType type = (MixedSlabBlock.MixedType)((Object)this.mixedState.getValue(MixedSlabBlock.TYPE));
            SlabBlock slab = this.blockEntity.map(entity -> entity.getBlock(towards)).orElse((SlabBlock)Blocks.STONE_SLAB);
            return new Sided(this.mixedState, this.blockEntity, towards, type.state(slab, towards));
        }
    }

    public record Sided(BlockState mixedState, Optional<MixedSlabBlockEntity> blockEntity, boolean towards, BlockState state) implements MixedContext
    {
        @Override
        public boolean replaceBlock(Block block) {
            return this.blockEntity.map(entity -> entity.setBlock(block, this.towards)).orElse(false);
        }

        @Override
        public Sided sided(boolean towards) {
            if (this.towards == towards) {
                return this;
            }
            return new Sideless(this.mixedState, this.blockEntity).sided(towards);
        }

        public Block block() {
            return this.state.getBlock();
        }

        public MixedHandler handler() {
            return MixedHandlers.getOrThrow(this.state.getBlock());
        }
    }
}

