/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.handlers;

import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.handlers.MixedContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public interface MixedHandler {
    default public MixedSlabBlock mixed() {
        return (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
    }

    default public void randomTick(MixedContext.Sided context, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    default public boolean emitsRedstonePower(MixedContext.Sided context) {
        return false;
    }

    default public int getStrongRedstonePower(MixedContext.Sided context, BlockGetter world, BlockPos pos, Direction direction) {
        return 0;
    }

    default public int getWeakRedstonePower(MixedContext.Sided context, BlockGetter world, BlockPos pos, Direction direction) {
        return 0;
    }

    default public void onProjectileHit(MixedContext.Sided context, Level world, BlockHitResult hit, Projectile projectile) {
    }

    default public void onSteppedOn(MixedContext.Sided context, Level world, BlockPos pos, Entity entity) {
    }

    default public void onLandedUpon(MixedContext.Sided context, Level world, BlockPos pos, Entity entity, double fallDistance) {
        entity.causeFallDamage(fallDistance, 1.0f, entity.damageSources().fall());
    }

    default public void onEntityLand(MixedContext.Sided context, BlockGetter world, Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    default public void precipitationTick(MixedContext.Sided context, Level world, BlockPos pos, Biome.Precipitation precipitation) {
    }

    default public void onBlockBreakStart(MixedContext.Sided context, Level world, BlockPos pos, Player player) {
    }

    default public void afterBreak(MixedContext.Sided context, Level world, Player player, BlockPos pos, @Nullable BlockEntity blockEntity, ItemStack tool) {
    }

    default public void scheduledTick(MixedContext.Sided context, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    default public void onStacksDropped(MixedContext.Sided context, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
    }

    default public InteractionResult onUse(MixedContext.Sided context, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    default public InteractionResult onUseWithItem(MixedContext.Sided context, ItemStack stack, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }
}

