/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.handlers;

import dev.micalobia.fullslabs.ducks.AxeItemDuck;
import dev.micalobia.fullslabs.handlers.MixedContext;
import dev.micalobia.fullslabs.handlers.MixedHandler;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class OxidizableMixedHandler
implements MixedHandler {
    public static final OxidizableMixedHandler INSTANCE = new OxidizableMixedHandler();

    private OxidizableMixedHandler() {
    }

    @Override
    public void randomTick(MixedContext.Sided context, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockState state = context.state();
        Block block = state.getBlock();
        if (!(block instanceof WeatheringCopper)) {
            return;
        }
        WeatheringCopper oxidizable = (WeatheringCopper)block;
        oxidizable.getNextState(state, world, pos, random).ifPresent(s -> context.replaceBlock(s.getBlock()));
    }

    @Override
    public InteractionResult onUseWithItem(MixedContext.Sided context, ItemStack stack, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        BlockState state = context.state();
        if (item instanceof AxeItemDuck) {
            AxeItemDuck axe = (AxeItemDuck)item;
            Optional<BlockState> stripped = axe.fullslabs$strippedState(world, pos, player, state, new UseOnContext(player, hand, hit));
            if (stripped.isPresent()) {
                boolean success = context.replaceBlock(stripped.get().getBlock());
                return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            return InteractionResult.PASS;
        }
        if (item instanceof HoneycombItem) {
            return this.useWaxOnBlock(context, stack, state, world, pos, player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult useWaxOnBlock(MixedContext context, ItemStack stack, BlockState state, Level world, BlockPos pos, Player player) {
        return HoneycombItem.getWaxed((BlockState)state).map(s -> {
            boolean success = context.replaceBlock(s.getBlock());
            if (!success) {
                return InteractionResult.PASS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
            }
            stack.consume(1, (LivingEntity)player);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            world.levelEvent((Entity)player, 3003, pos, 0);
            return InteractionResult.SUCCESS;
        }).orElse((InteractionResult)InteractionResult.PASS);
    }
}

