/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.loot;

import dev.architectury.event.events.common.LootEvent;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class VerticalLootTable
implements LootEvent.ModifyLootTable {
    private Map<ResourceKey<LootTable>, SlabBlock> cache = null;

    public void modifyLootTable(ResourceKey<LootTable> key, LootEvent.LootTableModificationContext context, boolean builtin) {
        SlabBlock slab2;
        if (!builtin) {
            return;
        }
        if (this.cache == null) {
            this.cache = VerticalSlabBlock.MAP_VIEW.keySet().stream().map(slab -> Map.entry(slab.getLootTable(), slab)).filter(entry -> ((Optional)entry.getKey()).isPresent()).collect(Collectors.toMap(entry -> (ResourceKey)((Optional)entry.getKey()).get(), Map.Entry::getValue));
        }
        if ((slab2 = this.cache.get(key)) == null) {
            return;
        }
        VerticalSlabBlock vertical = VerticalSlabBlock.getVertical(slab2);
        LootPool.Builder pool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)slab2)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)vertical).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalType.FULL)))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
        context.addPool(pool);
    }
}

