/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.mixin;

import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.config.Controls;
import dev.micalobia.fullslabs.handlers.MixedHandlers;
import dev.micalobia.fullslabs.util.SlabPlacement;
import dev.micalobia.fullslabs.util.Utility;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SlabBlock.class})
public class SlabBlockMixin {
    @Inject(method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void editPlacementRules(BlockPlaceContext ctx, CallbackInfoReturnable<BlockState> cir) {
        SlabBlock self = this.fullslabs$self();
        if (!VerticalSlabBlock.hasVertical(self)) {
            return;
        }
        BlockPos pos = ctx.getClickedPos();
        Level world = ctx.getLevel();
        BlockState state = world.getBlockState(pos);
        if (state.is((Block)VerticalSlabBlock.getVertical(self))) {
            cir.setReturnValue((Object)((BlockState)((BlockState)state.setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalType.FULL))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))));
        } else if (state.is((Block)self)) {
            cir.setReturnValue((Object)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))));
        } else if (Utility.isSlab(state)) {
            MixedSlabBlock mixed = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
            cir.setReturnValue((Object)((BlockState)mixed.defaultBlockState().setValue(MixedSlabBlock.TYPE, (Comparable)((Object)MixedSlabBlock.MixedType.fromState(state)))));
        } else {
            Direction target;
            Direction face = ctx.getClickedFace();
            FluidState fluidState = world.getFluidState(pos);
            Player player = ctx.getPlayer();
            if (player == null) {
                target = Direction.DOWN;
            } else {
                SlabPlacement.Mode mode = Controls.getPlacementMode(ctx.getPlayer().getUUID());
                target = SlabPlacement.getTargetedDirection(mode, face, ctx.getHorizontalDirection(), pos, ctx.getClickLocation());
            }
            cir.setReturnValue((Object)((BlockState)Utility.getTargetedState(this.fullslabs$self(), face, target, ctx.getRotation()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is((Fluid)Fluids.WATER)))));
        }
    }

    @Inject(method={"canBeReplaced(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/item/context/BlockPlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void editReplacementRules(BlockState state, BlockPlaceContext context, CallbackInfoReturnable<Boolean> cir) {
        Block block;
        SlabBlock self = this.fullslabs$self();
        if (!VerticalSlabBlock.hasVertical(self)) {
            return;
        }
        ItemStack stack = context.getItemInHand();
        SlabType type = (SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE);
        if (type != SlabType.DOUBLE && (block = ((BlockItem)stack.getItem()).getBlock()) instanceof SlabBlock && (block == self || MixedHandlers.hasHandler(block) && MixedHandlers.hasHandler((Block)self))) {
            if (context.replacingClickedOnBlock()) {
                cir.setReturnValue((Object)Utility.isInsideSlab(state, context.getClickedPos(), context.getClickLocation()));
                return;
            }
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Unique
    private SlabBlock fullslabs$self() {
        return (SlabBlock)this;
    }
}

