/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={TagLoader.class})
public class TagGroupLoaderMixin {
    @Shadow
    @Final
    private String directory;

    @ModifyReturnValue(method={"build(Ljava/util/Map;)Ljava/util/Map;"}, at={@At(value="RETURN")})
    private Map<ResourceLocation, List<Holder.Reference<Block>>> injectVerticalSlabTags(Map<ResourceLocation, List<Holder.Reference<Block>>> original) {
        if (!"tags/block".equals(this.directory)) {
            return original;
        }
        original.keySet().stream().filter(id -> id.getPath().contains("mineable/")).forEach(id -> {
            List list = (List)original.get(id);
            List<Holder.Reference> slabs = list.stream().map(Holder.Reference::value).filter(SlabBlock.class::isInstance).map(SlabBlock.class::cast).filter(VerticalSlabBlock::hasVertical).map(VerticalSlabBlock::getVertical).map(block -> (Holder.Reference)BuiltInRegistries.BLOCK.wrapAsHolder((Object)block)).toList();
            if (!slabs.isEmpty()) {
                ImmutableList updated = ImmutableList.builderWithExpectedSize((int)(list.size() + slabs.size())).addAll((Iterable)list).addAll(slabs).build();
                original.put((ResourceLocation)id, (List<Holder.Reference<Block>>)updated);
            }
        });
        return original;
    }
}

