/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.neoforge.client;

import dev.micalobia.fullslabs.FullSlabs;
import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.client.BlockFaceOverlay;
import dev.micalobia.fullslabs.client.FullSlabsClient;
import dev.micalobia.fullslabs.client.models.MixedSlabModel;
import dev.micalobia.fullslabs.client.models.VerticalSlabModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelLoader;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="fullslabs")
public final class FullSlabsNeoForgeClient {
    public static final Map<BlockState, StandaloneModelKey<BlockStateModel>> keys = new HashMap<BlockState, StandaloneModelKey<BlockStateModel>>();

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        FullSlabsClient.init();
    }

    @SubscribeEvent
    public static void registerStandalones(ModelEvent.RegisterStandalone event) {
        keys.clear();
        for (VerticalSlabBlock vertical : VerticalSlabBlock.MAP_VIEW.values()) {
            for (BlockState state : vertical.getStateDefinition().getPossibleStates()) {
                ResourceLocation id = VerticalSlabModel.makeModelId(state);
                StandaloneModelKey key = new StandaloneModelKey(() -> ((ResourceLocation)id).toString());
                event.register(key, (UnbakedStandaloneModel)new UnbakedGroupedWrapper(VerticalSlabModel.INSTANCE, state));
                keys.put(state, (StandaloneModelKey<BlockStateModel>)key);
            }
        }
        MixedSlabBlock mixed = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        for (BlockState state : mixed.getStateDefinition().getPossibleStates()) {
            ResourceLocation id = FullSlabs.id("block/mixed_slab/%s".formatted(((MixedSlabBlock.MixedType)((Object)state.getValue(MixedSlabBlock.TYPE))).getSerializedName()));
            StandaloneModelKey key = new StandaloneModelKey(() -> ((ResourceLocation)id).toString());
            event.register(key, (UnbakedStandaloneModel)new UnbakedGroupedWrapper(MixedSlabModel.INSTANCE, state));
            keys.put(state, (StandaloneModelKey<BlockStateModel>)key);
        }
    }

    @SubscribeEvent
    public static void mapStandalones(ModelEvent.ModifyBakingResult event) {
        ModelBakery.BakingResult result = event.getBakingResult();
        StandaloneModelLoader.BakedModels standaloneModels = result.standaloneModels();
        Map blockStateModels = event.getBakingResult().blockStateModels();
        for (VerticalSlabBlock vertical : VerticalSlabBlock.MAP_VIEW.values()) {
            for (BlockState state : vertical.getStateDefinition().getPossibleStates()) {
                StandaloneModelKey<BlockStateModel> key = keys.get(state);
                BlockStateModel model = (BlockStateModel)standaloneModels.get(key);
                blockStateModels.put(state, model);
            }
        }
        MixedSlabBlock mixed = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        for (BlockState state : mixed.getStateDefinition().getPossibleStates()) {
            StandaloneModelKey<BlockStateModel> key = keys.get(state);
            BlockStateModel model = (BlockStateModel)standaloneModels.get(key);
            blockStateModels.put(state, model);
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderLevelStageEvent.AfterEntities event) {
        Minecraft client = Minecraft.getInstance();
        if (client.options.hideGui) {
            return;
        }
        BlockFaceOverlay.renderFaceOverlay(event.getLevelRenderState());
    }

    public static class UnbakedGroupedWrapper
    implements UnbakedStandaloneModel<BlockStateModel> {
        private final BlockStateModel.UnbakedRoot model;
        private final BlockState state;

        public UnbakedGroupedWrapper(BlockStateModel.UnbakedRoot model, BlockState state) {
            this.model = model;
            this.state = state;
        }

        @NotNull
        public BlockStateModel bake(@NotNull ModelBaker baker) {
            return this.model.bake(this.state, baker);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            this.model.resolveDependencies(resolver);
        }
    }
}

