/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.neoforge.mixin;

import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.neoforge.FullSlabsNeoForge;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.neoforged.neoforge.model.data.ModelData;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@MethodsReturnNonnullByDefault
@Mixin(value={MixedSlabBlockEntity.class})
public abstract class MixedSlabBlockEntityMixin
extends BlockEntity {
    @Shadow
    public abstract BlockState getTowardsState();

    @Shadow
    public abstract BlockState getAwayState();

    public MixedSlabBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ModelData getModelData() {
        BlockState towardsState = this.getTowardsState();
        BlockState awayState = this.getAwayState();
        MixedSlabBlockEntity.ModelContext context = MixedSlabBlockEntity.ModelContext.fromStates(towardsState, awayState);
        return ModelData.of(FullSlabsNeoForge.MIXED_CONTEXT_MODEL_PROPERTY, (Object)context);
    }

    @Inject(method={"loadAdditional(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void updateModelAfterRead(ValueInput view, CallbackInfo ci) {
        this.requestModelDataUpdate();
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 19);
    }
}

