/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.util;

import com.google.common.collect.BiMap;
import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.handlers.MixedContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Utility {
    private static double wrapToMinus180to180(double value) {
        return value < 0.0 ? 180.0 - Math.abs(value) % 360.0 : value - 180.0;
    }

    public static BlockState getTargetedState(SlabBlock slab, Direction blockFace, Direction target, double cameraYaw) {
        VerticalSlabBlock vertical = VerticalSlabBlock.getVertical(slab);
        return switch (target) {
            case Direction.UP -> (BlockState)slab.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP);
            case Direction.DOWN -> (BlockState)slab.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM);
            default -> {
                Direction.Axis faceAxis = blockFace.getAxis();
                if (faceAxis == target.getAxis()) {
                    yield (BlockState)((BlockState)vertical.defaultBlockState().setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalType.AWAY))).setValue(VerticalSlabBlock.DIRECTION, (Comparable)target);
                }
                float altYaw = faceAxis.isVertical() ? target.toYRot() : blockFace.toYRot();
                double delta = Utility.wrapToMinus180to180(cameraYaw - (double)altYaw);
                boolean towards = faceAxis.isVertical() ? Math.abs(delta) < 90.0 : delta < 0.0 == (blockFace.getCounterClockWise() == target);
                yield (BlockState)((BlockState)vertical.defaultBlockState().setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY)))).setValue(VerticalSlabBlock.DIRECTION, (Comparable)(towards ? target : target.getOpposite()));
            }
        };
    }

    public static boolean isSlabWithVertical(ItemStack stack) {
        return Utility.isSlabWithVertical(stack.getItem());
    }

    public static boolean isSlabWithVertical(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && Utility.isSlabWithVertical((blockItem = (BlockItem)item).getBlock());
    }

    public static boolean isSlabWithVertical(BlockState state) {
        return Utility.isSlabWithVertical(state.getBlock());
    }

    public static boolean isSlabWithVertical(Block block) {
        SlabBlock slab;
        return block instanceof VerticalSlabBlock || block instanceof SlabBlock && VerticalSlabBlock.hasVertical(slab = (SlabBlock)block);
    }

    public static boolean isSlab(ItemStack stack) {
        return Utility.isSlab(stack.getItem());
    }

    public static boolean isSlab(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && Utility.isSlab((blockItem = (BlockItem)item).getBlock());
    }

    public static boolean isSlab(BlockState state) {
        return Utility.isSlab(state.getBlock());
    }

    public static boolean isSlab(Block block) {
        return block instanceof SlabBlock || block instanceof VerticalSlabBlock;
    }

    public static boolean isDoubleSlab(BlockState state) {
        return state.getBlock() instanceof SlabBlock && state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.DOUBLE || state.getBlock() instanceof VerticalSlabBlock && state.getValue(VerticalSlabBlock.TYPE) == VerticalSlabBlock.VerticalType.FULL;
    }

    public static boolean isInsideSlab(BlockState state, BlockPos blockPos, Vec3 hitPos) {
        Block block = state.getBlock();
        if (!Utility.isSlab(block)) {
            return false;
        }
        if (block instanceof SlabBlock) {
            SlabType type = (SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE);
            if (type == SlabType.DOUBLE) {
                return false;
            }
            double diff = hitPos.y - (double)blockPos.getY();
            return type == SlabType.BOTTOM ? diff >= 0.5 : diff <= 0.5;
        }
        VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        if (type == VerticalSlabBlock.VerticalType.FULL) {
            return false;
        }
        Direction dir = (Direction)state.getValue(VerticalSlabBlock.DIRECTION);
        dir = type == VerticalSlabBlock.VerticalType.TOWARDS ? dir : dir.getOpposite();
        return switch (dir) {
            case Direction.NORTH -> {
                if (hitPos.z - (double)blockPos.getZ() >= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (hitPos.z - (double)blockPos.getZ() <= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (hitPos.x - (double)blockPos.getX() >= 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (hitPos.x - (double)blockPos.getX() <= 0.5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static HitResult crosshair(Player player) {
        return player.pick(player.blockInteractionRange(), 1.0f, false);
    }

    public static HitResult crosshair(@Nullable Player player, boolean isClient) {
        if (isClient) {
            return Minecraft.getInstance().hitResult;
        }
        if (player == null) {
            throw new IllegalArgumentException("Player is null on serverside!");
        }
        return Utility.crosshair(player);
    }

    @Nullable
    public static StatePair breakHalf(BlockGetter view, BlockState state, BlockPos pos, HitResult crosshair) {
        Objects.requireNonNull(view);
        Objects.requireNonNull(state);
        Objects.requireNonNull(pos);
        Objects.requireNonNull(crosshair);
        Vec3 hit = crosshair.getLocation();
        Block block = state.getBlock();
        MixedSlabBlock mixed = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        if (state.is((Block)mixed)) {
            MixedSlabBlock.MixedType type = (MixedSlabBlock.MixedType)((Object)state.getValue(MixedSlabBlock.TYPE));
            boolean towards = type.isAxisTargetTowards(hit, pos);
            return mixed.forward(view, pos, ctx -> {
                MixedSlabBlockEntity entity = ctx.blockEntityOrThrow();
                return new StatePair(entity.getState(towards), entity.getState(!towards));
            });
        }
        if (!Utility.isDoubleSlab(state)) {
            return null;
        }
        MixedSlabBlock.MixedType type = MixedSlabBlock.MixedType.fromState(state);
        boolean towards = type.isAxisTargetTowards(hit, pos);
        if (block instanceof SlabBlock) {
            return new StatePair((BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(towards ? SlabType.TOP : SlabType.BOTTOM)), (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(towards ? SlabType.BOTTOM : SlabType.TOP)));
        }
        if (block instanceof VerticalSlabBlock) {
            return new StatePair((BlockState)state.setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY))), (BlockState)state.setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.AWAY : VerticalSlabBlock.VerticalType.TOWARDS))));
        }
        throw new AssertionError();
    }

    public static BlockState targetedHalf(BlockGetter world, BlockState state, BlockPos pos, Vec3 hit) {
        MixedSlabBlock mixed = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        if (!Utility.isDoubleSlab(state) && !state.is((Block)mixed)) {
            return state;
        }
        Block block = state.getBlock();
        if (block == mixed) {
            return mixed.forwardSideValue(world, pos, hit, MixedContext.Sided::state);
        }
        boolean towards = MixedSlabBlock.MixedType.fromState(state).isAxisTargetTowards(hit, pos);
        if (block instanceof SlabBlock) {
            return (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(towards ? SlabType.TOP : SlabType.BOTTOM));
        }
        return (BlockState)state.setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY)));
    }

    public static Direction slabDirection(BlockState state) {
        Block block = state.getBlock();
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SlabBlock.class, VerticalSlabBlock.class}, (Object)block2, n)) {
            case 0: {
                SlabBlock ignored = (SlabBlock)block2;
                SlabType type = (SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE);
                if (type == SlabType.DOUBLE) {
                    throw new IllegalArgumentException("Not a half-slab!");
                }
                return type == SlabType.TOP ? Direction.UP : Direction.DOWN;
            }
            case 1: {
                VerticalSlabBlock ignored = (VerticalSlabBlock)block2;
                VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.getValue(VerticalSlabBlock.TYPE));
                if (type == VerticalSlabBlock.VerticalType.FULL) {
                    throw new IllegalArgumentException("Not a half-slab!");
                }
                Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                return type == VerticalSlabBlock.VerticalType.TOWARDS ? direction : direction.getOpposite();
            }
        }
        throw new IllegalArgumentException("Not a half-slab!");
    }

    public static Optional<Block> getWaxed(Block unwaxed) {
        return Optional.ofNullable((Block)((BiMap)HoneycombItem.WAXABLES.get()).get((Object)unwaxed));
    }

    public record StatePair(BlockState towards, BlockState away) {
    }
}

