/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.database.DatabaseManager;
import dev.aevorinstudios.aevorinReports.gui.BookGUI;
import dev.aevorinstudios.aevorinReports.gui.ReportReasonContainerGUI;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BukkitReportCommand
implements CommandExecutor,
TabCompleter {
    private final BukkitPlugin plugin;

    public BukkitReportCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.report")) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(ChatColor.RED + "Usage: /report <player> [reason]");
            return true;
        }
        String targetPlayer = args[0];
        Player target = this.plugin.getServer().getPlayer(targetPlayer);
        if (target == null) {
            player.sendMessage(ChatColor.RED + "Player not found!");
            return true;
        }
        boolean allowSelfReporting = this.plugin.getConfig().getBoolean("reports.allow-self-reporting", true);
        if (!allowSelfReporting && player.getName().equalsIgnoreCase(targetPlayer)) {
            player.sendMessage(ChatColor.RED + "You cannot report yourself.");
            return true;
        }
        if (args.length > 1) {
            String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            if (reason.equalsIgnoreCase("custom")) {
                if (!this.plugin.getConfig().getBoolean("reports.allow-custom-reasons", true)) {
                    player.sendMessage(ChatColor.RED + this.plugin.getConfig().getString("messages.custom-reason-disabled", "Custom reasons are disabled."));
                    return true;
                }
                this.plugin.getCustomReasonHandler().startCustomReason(player, targetPlayer);
                player.sendMessage(ChatColor.GREEN + this.plugin.getConfig().getString("messages.enter-custom-reason", "Please enter your reason in the chat:"));
                return true;
            }
            this.createReport(player, targetPlayer, reason);
            return true;
        }
        this.showReportCategories(player, target.getName());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player) || !sender.hasPermission("aevorinreports.report")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            ArrayList<String> playerNames = new ArrayList<String>();
            String partialName = args[0].toLowerCase();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(partialName)) continue;
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>(this.plugin.getConfig().getStringList("reports.categories"));
            if (this.plugin.getConfig().getBoolean("reports.allow-custom-reasons", true)) {
                suggestions.add("custom");
            }
            String partialReason = args[1].toLowerCase();
            return suggestions.stream().filter(reason -> reason.toLowerCase().startsWith(partialReason)).toList();
        }
        return new ArrayList<String>();
    }

    public void createReport(Player reporter, String targetPlayer, String category) {
        LocalDateTime now = LocalDateTime.now();
        Report report = Report.builder().reporterUuid(reporter.getUniqueId()).reportedUuid(this.plugin.getServer().getOfflinePlayer(targetPlayer).getUniqueId()).reason(category).serverName(this.plugin.getServer().getName()).status(Report.ReportStatus.PENDING).isAnonymous(false).createdAt(now).updatedAt(now).build();
        DatabaseManager.getInstance().saveReport(report);
        for (Player staff : this.plugin.getServer().getOnlinePlayers()) {
            if (!staff.hasPermission("aevorinreports.notify")) continue;
            staff.sendMessage(ChatColor.RED + "[Reports] " + ChatColor.RED + reporter.getName() + ChatColor.WHITE + " has reported " + ChatColor.YELLOW + targetPlayer + ChatColor.WHITE + " for: " + ChatColor.YELLOW + category);
        }
        if (this.plugin.getConfig().getBoolean("proxy.enabled", false) && this.plugin.getTokenSyncManager() != null && this.plugin.getTokenSyncManager().isAuthenticated()) {
            HashMap<String, String> reportData = new HashMap<String, String>();
            reportData.put("id", String.valueOf(report.getId()));
            reportData.put("reporter_uuid", report.getReporterUuid().toString());
            reportData.put("reporter_name", reporter.getName());
            reportData.put("reported_uuid", report.getReportedUuid().toString());
            reportData.put("reported_name", targetPlayer);
            reportData.put("reason", report.getReason());
            reportData.put("server_name", report.getServerName());
            reportData.put("status", report.getStatus().toString());
            reportData.put("created_at", report.getCreatedAt().toString());
            this.plugin.getTokenSyncManager().sendMessage("NEW_REPORT", reportData).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.plugin.getLogger().info("Report #" + report.getId() + " successfully synced with proxy");
                } else {
                    this.plugin.getLogger().warning("Failed to sync report #" + report.getId() + " with proxy");
                }
            });
        }
        reporter.sendMessage(ChatColor.GREEN + "Your report has been submitted successfully!");
    }

    private void showReportCategories(Player player, String targetPlayer) {
        String guiType = this.plugin.getConfig().getString("reports.gui.type", "book");
        if (guiType.equalsIgnoreCase("container")) {
            new ReportReasonContainerGUI(this.plugin).showReasonContainerGUI(player, targetPlayer);
        } else {
            this.showReportBookGUI(player, targetPlayer);
        }
    }

    private void showReportBookGUI(Player player, String targetPlayer) {
        new BookGUI(this.plugin).showReportCategories(player, targetPlayer);
    }
}

