/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.config.ConfigManager;
import dev.aevorinstudios.aevorinReports.gui.BookGUI;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitReportsCommand
implements CommandExecutor,
TabCompleter {
    private final BukkitPlugin plugin;
    private final Map<UUID, Long> lastCommandTime = new HashMap<UUID, Long>();
    private final Map<Report.ReportStatus, List<Report>> reportCache = new HashMap<Report.ReportStatus, List<Report>>();
    private static final long COMMAND_COOLDOWN = 500L;
    private static final long CACHE_DURATION = 5000L;
    private long lastCacheUpdate = 0L;

    public BukkitReportsCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player) || !sender.hasPermission("aevorinreports.manage")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            ArrayList<String> groups = new ArrayList<String>();
            String partialGroup = args[0].toUpperCase();
            for (Report.ReportStatus status : Report.ReportStatus.values()) {
                if (!status.name().startsWith(partialGroup)) continue;
                groups.add(status.name());
            }
            return groups;
        }
        return new ArrayList<String>();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Report.ReportStatus status;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ConfigManager.getInstance().getMessage("messages.errors.player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.manage")) {
            sender.sendMessage(ConfigManager.getInstance().getMessage("messages.errors.no-permission"));
            return true;
        }
        if (args.length == 0) {
            this.showReportsBook(player);
            return true;
        }
        String group = args[0].toUpperCase();
        try {
            status = Report.ReportStatus.valueOf(group);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(ConfigManager.getInstance().getMessage("messages.errors.invalid-group"));
            return true;
        }
        this.showReportsBookByStatus(player, status);
        return true;
    }

    private void showReportsBook(Player player) {
        long lastTime;
        String guiType = this.plugin.getConfig().getString("reports.gui.type", "book");
        if (guiType.equalsIgnoreCase("container")) {
            this.showReportsContainerGUI(player);
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastCommandTime.getOrDefault(player.getUniqueId(), 0L).longValue()) < 500L) {
            return;
        }
        this.lastCommandTime.put(player.getUniqueId(), currentTime);
        if (currentTime - this.lastCacheUpdate > 5000L) {
            this.reportCache.clear();
            this.lastCacheUpdate = currentTime;
        }
        new BookGUI(this.plugin).showReportsBook(player);
    }

    private void showReportsBookByStatus(Player player, Report.ReportStatus status) {
        long lastTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastCommandTime.getOrDefault(player.getUniqueId(), 0L).longValue()) < 500L) {
            return;
        }
        this.lastCommandTime.put(player.getUniqueId(), currentTime);
        if (currentTime - this.lastCacheUpdate > 5000L) {
            this.reportCache.clear();
            this.lastCacheUpdate = currentTime;
        }
        new BookGUI(this.plugin).showReportsByStatus(player, status);
    }

    private void showReportsContainerGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)"Reports Menu");
        ItemStack pending = new ItemStack(Material.PAPER);
        ItemMeta pendingMeta = pending.getItemMeta();
        pendingMeta.setDisplayName("\u00a7ePending Reports");
        pendingMeta.setLore(List.of("\u00a77View all pending reports.", "\u00a7eClick to view!"));
        pending.setItemMeta(pendingMeta);
        gui.setItem(10, pending);
        ItemStack resolved = new ItemStack(Material.BOOK);
        ItemMeta resolvedMeta = resolved.getItemMeta();
        resolvedMeta.setDisplayName("\u00a7aResolved Reports");
        resolvedMeta.setLore(List.of("\u00a77View all resolved reports.", "\u00a7eClick to view!"));
        resolved.setItemMeta(resolvedMeta);
        gui.setItem(13, resolved);
        ItemStack rejected = new ItemStack(Material.BARRIER);
        ItemMeta rejectedMeta = rejected.getItemMeta();
        rejectedMeta.setDisplayName("\u00a7cRejected Reports");
        rejectedMeta.setLore(List.of("\u00a77View all rejected reports.", "\u00a7eClick to view!"));
        rejected.setItemMeta(rejectedMeta);
        gui.setItem(16, rejected);
        player.openInventory(gui);
    }
}

