/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.gui.ReportManageGUI;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SetReportStatusCommand
implements CommandExecutor,
TabCompleter {
    private final BukkitPlugin plugin;

    public SetReportStatusCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.manage")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
            return true;
        }
        if (args.length != 3 || !args[1].equalsIgnoreCase("to")) {
            player.sendMessage(ChatColor.RED + "Usage: /setreportstatus <id> to <status>");
            return true;
        }
        try {
            long reportId = Long.parseLong(args[0]);
            String statusStr = args[2].toUpperCase();
            Report.ReportStatus newStatus = Report.ReportStatus.valueOf(statusStr);
            Report report = this.plugin.getDatabaseManager().getReport(reportId);
            if (report == null) {
                player.sendMessage(ChatColor.RED + "Report not found!");
                return true;
            }
            if (report.getStatus() == newStatus) {
                player.sendMessage(ChatColor.YELLOW + "Report is already in that status!");
                return true;
            }
            report.setStatus(newStatus);
            this.plugin.getDatabaseManager().updateReport(report);
            player.sendMessage(ChatColor.DARK_GRAY + "[Report System] " + ChatColor.GRAY + "ID: " + reportId + " \u2192 " + newStatus.name());
            this.plugin.getLogger().fine("Report " + reportId + " status changed to " + newStatus.name() + " by " + player.getName());
            new ReportManageGUI(this.plugin).open(player, report);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ChatColor.RED + "Invalid report ID!");
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(ChatColor.RED + "Invalid status! Valid: " + Arrays.toString((Object[])Report.ReportStatus.values()));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("aevorinreports.manage")) {
            return new ArrayList<String>();
        }
        if (args.length == 2) {
            return List.of("to");
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("to")) {
            return Arrays.stream(Report.ReportStatus.values()).map(Enum::name).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

