/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.gui.BookGUI;
import dev.aevorinstudios.aevorinReports.reports.Report;
import dev.aevorinstudios.aevorinReports.utils.PlayerNameResolver;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewReportCommand
implements CommandExecutor {
    private final BukkitPlugin plugin;

    public ViewReportCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.manage")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(ChatColor.RED + "Usage: /viewreport <id>");
            return true;
        }
        try {
            long reportId = Long.parseLong(args[0]);
            this.showReportDetails(player, reportId);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ChatColor.RED + "Invalid report ID!");
        }
        return true;
    }

    private void showReportDetails(Player player, long reportId) {
        Report report = this.plugin.getDatabaseManager().getReport(reportId);
        if (report == null) {
            player.sendMessage(ChatColor.RED + "Report not found!");
            return;
        }
        String guiType = this.plugin.getConfig().getString("reports.gui.type", "book").toLowerCase();
        if (guiType.equals("book")) {
            new BookGUI(this.plugin).showReportDetails(player, report);
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)("Manage Report " + report.getId()));
        ItemStack background = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, background);
        }
        String reporterName = report.isAnonymous() ? "Anonymous" : PlayerNameResolver.resolvePlayerName(report.getReporter());
        String reportedName = PlayerNameResolver.resolvePlayerName(report.getReported());
        if (reporterName == null) {
            reporterName = "Unknown";
        }
        if (reportedName == null) {
            reportedName = "Unknown";
        }
        ItemStack info = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta infoMeta = info.getItemMeta();
        infoMeta.setDisplayName("\u00a7b\u00a7lReport Details");
        infoMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        infoMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        infoMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Reporter: \u00a7f" + reporterName, "\u00a77Reported: \u00a7f" + reportedName, "\u00a77Reason: \u00a7f" + report.getCategory(), "\u00a77Status: \u00a7f" + report.getStatus(), "\u00a77ID: \u00a7f" + report.getId(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500"));
        info.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        info.setItemMeta(infoMeta);
        gui.setItem(22, info);
        ItemStack glass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.setDisplayName(" ");
            glass.setItemMeta(glassMeta);
        }
        for (int slot : new int[]{12, 13, 14, 21, 23, 30, 31, 32}) {
            gui.setItem(slot, glass);
        }
        if (report.getStatus() != Report.ReportStatus.PENDING) {
            ItemStack pending = new ItemStack(Material.HOPPER);
            ItemMeta pendingMeta = pending.getItemMeta();
            pendingMeta.setDisplayName("\u00a76\u00a7lMove to Pending");
            pendingMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Set this report as pending for review.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a76Click to change status"));
            pending.setItemMeta(pendingMeta);
            gui.setItem(45, pending);
        }
        if (report.getStatus() != Report.ReportStatus.RESOLVED) {
            ItemStack resolved = new ItemStack(Material.EMERALD_BLOCK);
            ItemMeta resolvedMeta = resolved.getItemMeta();
            resolvedMeta.setDisplayName("\u00a7a\u00a7lMove to Resolved");
            resolvedMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Mark this report as resolved.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7aClick to change status"));
            resolved.setItemMeta(resolvedMeta);
            gui.setItem(49, resolved);
        }
        if (report.getStatus() != Report.ReportStatus.REJECTED) {
            ItemStack rejected = new ItemStack(Material.BARRIER);
            ItemMeta rejectedMeta = rejected.getItemMeta();
            rejectedMeta.setDisplayName("\u00a7c\u00a7lMove to Rejected");
            rejectedMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Reject this report as invalid.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7cClick to change status"));
            rejected.setItemMeta(rejectedMeta);
            gui.setItem(53, rejected);
        }
        player.openInventory(gui);
    }
}

