/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.database;

import dev.aevorinstudios.aevorinReports.reports.Report;
import dev.aevorinstudios.aevorinreports.libs.hikari.HikariConfig;
import dev.aevorinstudios.aevorinreports.libs.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DatabaseManager {
    private HikariDataSource dataSource;
    private static DatabaseManager instance;

    public boolean testConnection() {
        boolean bl;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                bl = conn.isValid(5);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    public DatabaseManager(String host, int port, String database, String username, String password) {
        instance = this;
        this.initializeDataSource(host, port, database, username, password);
        this.createTables();
    }

    public DatabaseManager(String filePath) {
        instance = this;
        this.initializeSQLiteDataSource(filePath);
        this.createTables();
    }

    public List<Report> getResolvedReportsBefore(LocalDateTime cutoff) {
        String sql = "SELECT * FROM reports WHERE status = 'RESOLVED' AND updated_at < ?";
        ArrayList<Report> reports = new ArrayList<Report>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setTimestamp(1, Timestamp.valueOf(cutoff));
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    reports.add(Report.builder().id(rs.getLong("id")).reporterUuid(UUID.fromString(rs.getString("reporter_uuid"))).reportedUuid(UUID.fromString(rs.getString("reported_uuid"))).reason(rs.getString("reason")).serverName(rs.getString("server_name")).status(Report.ReportStatus.valueOf(rs.getString("status"))).isAnonymous(rs.getBoolean("is_anonymous")).createdAt(rs.getTimestamp("created_at").toLocalDateTime()).updatedAt(rs.getTimestamp("updated_at").toLocalDateTime()).evidenceData(rs.getString("evidence_data")).coordinates(rs.getString("coordinates")).world(rs.getString("world")).build());
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to fetch resolved reports", e);
        }
        return reports;
    }

    public List<Report> getRejectedReportsBefore(LocalDateTime cutoff) {
        String sql = "SELECT * FROM reports WHERE status = 'INVALID' AND updated_at < ?";
        ArrayList<Report> reports = new ArrayList<Report>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setTimestamp(1, Timestamp.valueOf(cutoff));
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    reports.add(Report.builder().id(rs.getLong("id")).reporterUuid(UUID.fromString(rs.getString("reporter_uuid"))).reportedUuid(UUID.fromString(rs.getString("reported_uuid"))).reason(rs.getString("reason")).serverName(rs.getString("server_name")).status(Report.ReportStatus.valueOf(rs.getString("status"))).isAnonymous(rs.getBoolean("is_anonymous")).createdAt(rs.getTimestamp("created_at").toLocalDateTime()).updatedAt(rs.getTimestamp("updated_at").toLocalDateTime()).evidenceData(rs.getString("evidence_data")).coordinates(rs.getString("coordinates")).world(rs.getString("world")).build());
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to fetch rejected reports", e);
        }
        return reports;
    }

    public void deleteReport(Long id) {
        String sql = "DELETE FROM reports WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete report", e);
        }
    }

    public List<Report> getReportsByStatus(Report.ReportStatus status) {
        String sql = "SELECT * FROM reports WHERE status = ?";
        ArrayList<Report> reports = new ArrayList<Report>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, status.name());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    reports.add(Report.builder().id(rs.getLong("id")).reporterUuid(UUID.fromString(rs.getString("reporter_uuid"))).reportedUuid(UUID.fromString(rs.getString("reported_uuid"))).reason(rs.getString("reason")).serverName(rs.getString("server_name")).status(Report.ReportStatus.valueOf(rs.getString("status"))).isAnonymous(rs.getBoolean("is_anonymous")).createdAt(rs.getTimestamp("created_at").toLocalDateTime()).updatedAt(rs.getTimestamp("updated_at").toLocalDateTime()).evidenceData(rs.getString("evidence_data")).coordinates(rs.getString("coordinates")).world(rs.getString("world")).build());
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to fetch reports by status: " + status, e);
        }
        return reports;
    }

    public void deleteOldReports(Report.ReportStatus status, LocalDateTime threshold) {
        String sql = "DELETE FROM reports WHERE status = ? AND updated_at < ?";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, status.name());
            stmt.setTimestamp(2, Timestamp.valueOf(threshold));
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete old reports with status: " + status, e);
        }
    }

    public List<Report> getActiveReports() {
        return this.getReportsByStatus(Report.ReportStatus.PENDING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Report getReport(long id) {
        String sql = "SELECT * FROM reports WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                Report report = Report.builder().id(rs.getLong("id")).reporterUuid(UUID.fromString(rs.getString("reporter_uuid"))).reportedUuid(UUID.fromString(rs.getString("reported_uuid"))).reason(rs.getString("reason")).serverName(rs.getString("server_name")).status(Report.ReportStatus.valueOf(rs.getString("status"))).isAnonymous(rs.getBoolean("is_anonymous")).createdAt(rs.getTimestamp("created_at").toLocalDateTime()).updatedAt(rs.getTimestamp("updated_at").toLocalDateTime()).evidenceData(rs.getString("evidence_data")).coordinates(rs.getString("coordinates")).world(rs.getString("world")).build();
                return report;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to fetch report with id: " + id, e);
        }
    }

    private void initializeSQLiteDataSource(String filePath) {
        try {
            File dbFile = new File(filePath);
            File dbDir = dbFile.getParentFile();
            if (dbDir != null && !dbDir.exists() && !dbDir.mkdirs()) {
                throw new RuntimeException("Failed to create database directory: " + dbDir.getAbsolutePath());
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:sqlite:" + filePath);
            config.setDriverClassName("org.sqlite.JDBC");
            config.setMaximumPoolSize(1);
            config.setConnectionTimeout(30000L);
            config.setIdleTimeout(600000L);
            config.setMaxLifetime(1800000L);
            this.dataSource = new HikariDataSource(config);
            try (Connection conn = this.dataSource.getConnection();){
                if (!conn.isValid(5)) {
                    throw new SQLException("Failed to validate database connection");
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize SQLite database connection", e);
        }
    }

    private void initializeDataSource(String host, int port, String database, String username, String password) {
        int maxRetries = 3;
        int retryDelay = 5000;
        int attempts = 0;
        while (attempts < maxRetries) {
            try {
                HikariConfig config = new HikariConfig();
                config.setJdbcUrl(String.format("jdbc:mysql://%s:%d/%s?useSSL=false&allowPublicKeyRetrieval=true", host, port, database));
                config.setUsername(username);
                config.setPassword(password);
                config.setMaximumPoolSize(10);
                config.setMinimumIdle(5);
                config.setConnectionTimeout(30000L);
                config.setIdleTimeout(600000L);
                config.setMaxLifetime(1800000L);
                config.setConnectionTestQuery("SELECT 1");
                config.setValidationTimeout(5000L);
                config.setInitializationFailTimeout(1L);
                config.addDataSourceProperty("cachePrepStmts", "true");
                config.addDataSourceProperty("prepStmtCacheSize", "250");
                config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
                config.addDataSourceProperty("useUnicode", "true");
                config.addDataSourceProperty("characterEncoding", "utf8");
                config.addDataSourceProperty("serverTimezone", "UTC");
                this.dataSource = new HikariDataSource(config);
                try (Connection conn = this.dataSource.getConnection();){
                    if (!conn.isValid(5)) {
                        throw new SQLException("Failed to validate database connection");
                    }
                }
                return;
            }
            catch (SQLException e) {
                if (++attempts >= maxRetries) continue;
                try {
                    Thread.sleep(retryDelay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw new RuntimeException("Failed to initialize database connection pool after " + maxRetries + " attempts");
    }

    private void createTables() {
        try (Connection conn = this.getConnection();){
            String createReportsTable = this.dataSource.getJdbcUrl().contains("sqlite") ? "CREATE TABLE IF NOT EXISTS reports (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    reporter_uuid VARCHAR(36) NOT NULL,\n    reported_uuid VARCHAR(36) NOT NULL,\n    reason TEXT NOT NULL,\n    server_name VARCHAR(64) NOT NULL,\n    status VARCHAR(32) NOT NULL DEFAULT 'PENDING',\n    is_anonymous BOOLEAN DEFAULT 0,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    evidence_data TEXT,\n    coordinates VARCHAR(64),\n    world VARCHAR(64)\n)\n" : "CREATE TABLE IF NOT EXISTS reports (\n    id BIGINT AUTO_INCREMENT PRIMARY KEY,\n    reporter_uuid VARCHAR(36) NOT NULL,\n    reported_uuid VARCHAR(36) NOT NULL,\n    reason TEXT NOT NULL,\n    server_name VARCHAR(64) NOT NULL,\n    status VARCHAR(32) NOT NULL DEFAULT 'PENDING',\n    is_anonymous BOOLEAN DEFAULT 0\n)\n";
            try (PreparedStatement stmt = conn.prepareStatement(createReportsTable);){
                stmt.executeUpdate();
            }
            String createCommentsTable = this.dataSource.getJdbcUrl().contains("sqlite") ? "CREATE TABLE IF NOT EXISTS report_comments (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    report_id BIGINT NOT NULL,\n    staff_uuid VARCHAR(36) NOT NULL,\n    comment TEXT NOT NULL,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    FOREIGN KEY (report_id) REFERENCES reports(id) ON DELETE CASCADE\n)\n" : "CREATE TABLE IF NOT EXISTS report_comments (\n    id BIGINT AUTO_INCREMENT PRIMARY KEY,\n    report_id BIGINT NOT NULL,\n    staff_uuid VARCHAR(36) NOT NULL,\n    comment TEXT NOT NULL,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    FOREIGN KEY (report_id) REFERENCES reports(id) ON DELETE CASCADE\n)\n";
            try (PreparedStatement stmt = conn.prepareStatement(createCommentsTable);){
                stmt.executeUpdate();
            }
            String createHistoryTable = this.dataSource.getJdbcUrl().contains("sqlite") ? "CREATE TABLE IF NOT EXISTS report_history (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    report_id BIGINT NOT NULL,\n    staff_uuid VARCHAR(36) NOT NULL,\n    action VARCHAR(32) NOT NULL,\n    details TEXT,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    FOREIGN KEY (report_id) REFERENCES reports(id) ON DELETE CASCADE\n)\n" : "CREATE TABLE IF NOT EXISTS report_history (\n    id BIGINT AUTO_INCREMENT PRIMARY KEY,\n    report_id BIGINT NOT NULL,\n    staff_uuid VARCHAR(36) NOT NULL,\n    action VARCHAR(32) NOT NULL,\n    details TEXT,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    FOREIGN KEY (report_id) REFERENCES reports(id) ON DELETE CASCADE\n)\n";
            try (PreparedStatement stmt = conn.prepareStatement(createHistoryTable);){
                stmt.executeUpdate();
            }
            String createTokensTable = this.dataSource.getJdbcUrl().contains("sqlite") ? "CREATE TABLE IF NOT EXISTS server_tokens (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    server_name VARCHAR(64) UNIQUE NOT NULL,\n    token VARCHAR(128) NOT NULL,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n)\n" : "CREATE TABLE IF NOT EXISTS server_tokens (\n    id BIGINT AUTO_INCREMENT PRIMARY KEY,\n    server_name VARCHAR(64) UNIQUE NOT NULL,\n    token VARCHAR(128) NOT NULL,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n)\n";
            try (PreparedStatement stmt = conn.prepareStatement(createTokensTable);){
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void updateReport(Report report) {
        String sql = "UPDATE reports SET reporter_uuid = ?, reported_uuid = ?, reason = ?, server_name = ?, status = ?, is_anonymous = ?, updated_at = ?, evidence_data = ?, coordinates = ?, world = ? WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, report.getReporterUuid().toString());
            stmt.setString(2, report.getReportedUuid().toString());
            stmt.setString(3, report.getReason());
            stmt.setString(4, report.getServerName());
            stmt.setString(5, report.getStatus().name());
            stmt.setBoolean(6, report.isAnonymous());
            stmt.setTimestamp(7, Timestamp.valueOf(report.getUpdatedAt()));
            stmt.setString(8, report.getEvidenceData());
            stmt.setString(9, report.getCoordinates());
            stmt.setString(10, report.getWorld());
            stmt.setLong(11, report.getId());
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new RuntimeException("Failed to update report: Report not found");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update report", e);
        }
    }

    public void saveReport(Report report) {
        String sql = "INSERT INTO reports (reporter_uuid, reported_uuid, reason, server_name, status, is_anonymous, created_at, updated_at, evidence_data, coordinates, world) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql, 1);){
            stmt.setString(1, report.getReporterUuid().toString());
            stmt.setString(2, report.getReportedUuid().toString());
            stmt.setString(3, report.getReason());
            stmt.setString(4, report.getServerName());
            stmt.setString(5, report.getStatus().name());
            stmt.setBoolean(6, report.isAnonymous());
            stmt.setTimestamp(7, Timestamp.valueOf(report.getCreatedAt()));
            stmt.setTimestamp(8, Timestamp.valueOf(report.getUpdatedAt()));
            stmt.setString(9, report.getEvidenceData());
            stmt.setString(10, report.getCoordinates());
            stmt.setString(11, report.getWorld());
            stmt.executeUpdate();
            try (ResultSet generatedKeys = stmt.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    report.setId(generatedKeys.getLong(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save report", e);
        }
    }

    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    public static DatabaseManager getInstance() {
        return instance;
    }
}

