/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.gui;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.reports.Report;
import dev.aevorinstudios.aevorinReports.utils.PlayerNameResolver;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookGUI {
    private final BukkitPlugin plugin;
    private static final int ITEMS_PER_PAGE = 8;

    public BookGUI(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void showReportCategories(Player player, String targetPlayer) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle("Report Categories");
        meta.setAuthor("Server");
        List categories = this.plugin.getConfig().getStringList("reports.categories");
        ArrayList<BaseComponent[]> pages = new ArrayList<BaseComponent[]>();
        ComponentBuilder currentPage = new ComponentBuilder("\u00a74Reporting Player:\n");
        currentPage.append("\u00a7c" + targetPlayer + "\n\n");
        currentPage.append("\u00a74Reasons:\n");
        int itemsOnPage = 0;
        for (String category : categories) {
            if (itemsOnPage >= 8) {
                pages.add(currentPage.create());
                currentPage = new ComponentBuilder("");
                itemsOnPage = 0;
            }
            TextComponent categoryText = new TextComponent("\u00a7c\u2022 " + category);
            categoryText.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/report " + targetPlayer + " " + category));
            categoryText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to report for: \u00a7f" + category).create()));
            currentPage.append((BaseComponent)categoryText);
            if (itemsOnPage < 7) {
                currentPage.append("\n");
            }
            ++itemsOnPage;
        }
        if (itemsOnPage > 0) {
            pages.add(currentPage.create());
        }
        meta.spigot().setPages(pages);
        book.setItemMeta((ItemMeta)meta);
        player.openBook(book);
    }

    public void showReportsBook(Player player) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle("Reports Category");
        meta.setAuthor("Server");
        ComponentBuilder page = new ComponentBuilder("\u00a74Reports Category\n\n");
        TextComponent pendingButton = new TextComponent("\u00a76\u2022 Pending Reports");
        pendingButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reports pending"));
        pendingButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to view pending reports").create()));
        page.append((BaseComponent)pendingButton).append("\n\n");
        TextComponent resolvedButton = new TextComponent("\u00a7a\u2022 Resolved Reports");
        resolvedButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reports resolved"));
        resolvedButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to view resolved reports").create()));
        page.append((BaseComponent)resolvedButton).append("\n\n");
        TextComponent rejectedButton = new TextComponent("\u00a7c\u2022 Rejected Reports");
        rejectedButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reports rejected"));
        rejectedButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to view rejected reports").create()));
        page.append((BaseComponent)rejectedButton);
        meta.spigot().setPages((BaseComponent[][])new BaseComponent[][]{page.create()});
        book.setItemMeta((ItemMeta)meta);
        player.openBook(book);
    }

    public void showReportsByStatus(Player player, Report.ReportStatus status) {
        List<Report> reports = this.plugin.getDatabaseManager().getReportsByStatus(status);
        if (reports.isEmpty()) {
            player.sendMessage("\u00a7cNo " + status.toString().toLowerCase() + " reports found.");
            return;
        }
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle(status + " Reports");
        meta.setAuthor("Server");
        ArrayList<BaseComponent[]> pages = new ArrayList<BaseComponent[]>();
        int itemsOnPage = 0;
        int reportNumber = 1;
        ComponentBuilder currentPage = new ComponentBuilder("\u00a74" + status + " Reports\n");
        currentPage.append("\u00a77Total: " + reports.size() + "\n\n");
        for (Report report : reports) {
            if (itemsOnPage >= 7) {
                currentPage.append("\n\n");
                TextComponent backButton = new TextComponent("\u00a78\u00ab Back to Categories");
                backButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reports"));
                backButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to go back to report categories").create()));
                currentPage.append((BaseComponent)backButton);
                pages.add(currentPage.create());
                currentPage = new ComponentBuilder("");
                itemsOnPage = 0;
            }
            String reportedName = PlayerNameResolver.resolvePlayerName(report.getReported());
            TextComponent reportEntry = new TextComponent("\u00a74" + reportNumber + ". \u00a7c" + reportedName);
            reportEntry.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/viewreport " + report.getId()));
            reportEntry.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to view details").create()));
            currentPage.append((BaseComponent)reportEntry).append("\n");
            ++itemsOnPage;
            ++reportNumber;
        }
        if (itemsOnPage > 0) {
            currentPage.append("\n\n");
            TextComponent backButton = new TextComponent("\u00a78\u00ab Back to Categories");
            backButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reports"));
            backButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to go back to report categories").create()));
            currentPage.append((BaseComponent)backButton);
            pages.add(currentPage.create());
        }
        meta.spigot().setPages(pages);
        book.setItemMeta((ItemMeta)meta);
        player.openBook(book);
    }

    public void showReportDetails(Player player, Report report) {
        String guiType = this.plugin.getConfig().getString("reports.gui.type", "book").toLowerCase();
        if (guiType.equals("book")) {
            this.showReportDetailsBook(player, report);
        } else {
            this.showReportDetailsChest(player, report);
        }
    }

    private void showReportDetailsBook(Player player, Report report) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle("Report Details");
        meta.setAuthor("Server");
        ComponentBuilder page = new ComponentBuilder("\u00a7cReport Details\n\n");
        String reporterName = report.isAnonymous() ? "Anonymous" : PlayerNameResolver.resolvePlayerName(report.getReporter());
        String reportedName = PlayerNameResolver.resolvePlayerName(report.getReported());
        page.append("\u00a77Reporter: \u00a7a" + reporterName + "\n");
        page.append("\u00a77Reported: \u00a7c" + reportedName + "\n");
        page.append("\u00a77Reason: \u00a77" + report.getCategory() + "\n");
        page.append("\u00a77Status: \u00a7c" + report.getStatus() + "\n");
        page.append("\u00a77ID: \u00a7f" + report.getId() + "\n\n");
        page.append("\u00a78Click to change status\n");
        if (report.getStatus() == Report.ReportStatus.PENDING) {
            TextComponent resolveButton = new TextComponent("\u00a7a\u2714 Mark as Resolved\n");
            resolveButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/setreportstatus " + report.getId() + " to RESOLVED"));
            resolveButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to mark as resolved").create()));
            page.append((BaseComponent)resolveButton);
            TextComponent rejectButton = new TextComponent("\u00a7c\u2718 Mark as Rejected\n");
            rejectButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/setreportstatus " + report.getId() + " to REJECTED"));
            rejectButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to mark as rejected").create()));
            page.append((BaseComponent)rejectButton);
        } else {
            TextComponent pendingButton = new TextComponent("\u00a76\u26a0 Set as Pending\n");
            pendingButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/setreportstatus " + report.getId() + " to PENDING"));
            pendingButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click to return to pending").create()));
            page.append((BaseComponent)pendingButton);
        }
        TextComponent backButton = new TextComponent("\n\u00a78\u00ab Back to Full List");
        backButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reports " + report.getStatus().toString().toLowerCase()));
        backButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Return to report categories").create()));
        page.append((BaseComponent)backButton);
        meta.spigot().setPages((BaseComponent[][])new BaseComponent[][]{page.create()});
        book.setItemMeta((ItemMeta)meta);
        player.openBook(book);
    }

    private void showReportDetailsChest(Player player, Report report) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)("Manage Report " + report.getId()));
        ItemStack background = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, background);
        }
        String reporterName = report.isAnonymous() ? "Anonymous" : PlayerNameResolver.resolvePlayerName(report.getReporter());
        String reportedName = PlayerNameResolver.resolvePlayerName(report.getReported());
        if (reporterName == null) {
            reporterName = "Unknown";
        }
        if (reportedName == null) {
            reportedName = "Unknown";
        }
        ItemStack info = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta infoMeta = info.getItemMeta();
        infoMeta.setDisplayName("\u00a7b\u00a7lReport Details");
        infoMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        infoMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        infoMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Reporter: \u00a7f" + reporterName, "\u00a77Reported: \u00a7f" + reportedName, "\u00a77Reason: \u00a7f" + report.getCategory(), "\u00a77Status: \u00a7f" + report.getStatus(), "\u00a77ID: \u00a7f" + report.getId(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500"));
        info.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        info.setItemMeta(infoMeta);
        gui.setItem(22, info);
        ItemStack glass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.setDisplayName(" ");
            glass.setItemMeta(glassMeta);
        }
        for (int slot : new int[]{12, 13, 14, 21, 23, 30, 31, 32}) {
            gui.setItem(slot, glass);
        }
        if (report.getStatus() != Report.ReportStatus.PENDING) {
            ItemStack pending = new ItemStack(Material.HOPPER);
            ItemMeta pendingMeta = pending.getItemMeta();
            pendingMeta.setDisplayName("\u00a76\u00a7lMove to Pending");
            pendingMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Set this report as pending for review.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a76Click to change status"));
            pending.setItemMeta(pendingMeta);
            gui.setItem(45, pending);
        }
        if (report.getStatus() != Report.ReportStatus.RESOLVED) {
            ItemStack resolved = new ItemStack(Material.EMERALD_BLOCK);
            ItemMeta resolvedMeta = resolved.getItemMeta();
            resolvedMeta.setDisplayName("\u00a7a\u00a7lMove to Resolved");
            resolvedMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Mark this report as resolved.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7aClick to change status"));
            resolved.setItemMeta(resolvedMeta);
            gui.setItem(49, resolved);
        }
        if (report.getStatus() != Report.ReportStatus.REJECTED) {
            ItemStack rejected = new ItemStack(Material.BARRIER);
            ItemMeta rejectedMeta = rejected.getItemMeta();
            rejectedMeta.setDisplayName("\u00a7c\u00a7lMove to Rejected");
            rejectedMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Reject this report as invalid.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7cClick to change status"));
            rejected.setItemMeta(rejectedMeta);
            gui.setItem(53, rejected);
        }
        player.openInventory(gui);
    }
}

