/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.gui;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ReportReasonContainerGUI
implements Listener {
    private final BukkitPlugin plugin;
    private final Map<Player, Integer> playerPages = new HashMap<Player, Integer>();
    private final Map<Player, String> playerTargets = new HashMap<Player, String>();

    public ReportReasonContainerGUI(BukkitPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!event.getView().getTitle().startsWith("Report: ")) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        String targetPlayer = this.playerTargets.get(player);
        if (targetPlayer == null) {
            return;
        }
        if (clickedItem.getType() == Material.ARROW) {
            int currentPage = this.playerPages.getOrDefault(player, 1);
            if (meta.getDisplayName().contains("Next Page")) {
                this.showReasonContainerGUI(player, targetPlayer, currentPage + 1);
            } else if (meta.getDisplayName().contains("Previous Page") && currentPage > 1) {
                this.showReasonContainerGUI(player, targetPlayer, currentPage - 1);
            }
            return;
        }
        if (clickedItem.getType() == Material.PAPER) {
            String reason = meta.getDisplayName().replace("\u00a7c", "");
            player.closeInventory();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.performCommand("report " + targetPlayer + " " + reason));
        }
    }

    public void showReasonContainerGUI(Player player, String targetPlayer) {
        this.showReasonContainerGUI(player, targetPlayer, 1);
    }

    private void showReasonContainerGUI(Player player, String targetPlayer, int page) {
        int[] slots;
        this.playerPages.put(player, page);
        this.playerTargets.put(player, targetPlayer);
        List reasons = this.plugin.getConfig().getStringList("reports.categories");
        if (reasons.isEmpty()) {
            reasons = new ArrayList<String>(List.of("Hacking/Cheating", "Harassment/Bullying", "Inappropriate Language", "Spam/Advertisement", "Griefing/Vandalism", "Exploiting Bugs", "Inappropriate Skin/Name"));
        }
        reasons = reasons.stream().filter(reason -> !reason.equalsIgnoreCase("Other")).collect(Collectors.toList());
        int size = 54;
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)("Report: " + targetPlayer));
        ItemStack background = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (int i = 0; i < size; ++i) {
            gui.setItem(i, background);
        }
        if (page == 1) {
            ItemStack bookIcon = new ItemStack(Material.BOOK);
            ItemMeta bookMeta = bookIcon.getItemMeta();
            if (bookMeta != null) {
                bookMeta.setDisplayName("\u00a74Reporting: \u00a7c" + targetPlayer);
                bookMeta.setLore(List.of("\u00a77", "\u00a7fSelect a reason to report this player", "\u00a7fClick on any icon to submit your report", "\u00a77"));
                bookIcon.setItemMeta(bookMeta);
            }
            gui.setItem(13, bookIcon);
            slots = new int[]{29, 30, 31, 32, 33, 38, 39, 40, 41, 42};
        } else {
            slots = new int[]{11, 12, 13, 14, 15, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 38, 39, 40, 41, 42};
        }
        int itemsPerPage = slots.length;
        int totalPages = (int)Math.ceil((double)reasons.size() / (double)itemsPerPage);
        int startIndex = (page - 1) * itemsPerPage;
        int endIndex = Math.min(reasons.size(), startIndex + itemsPerPage);
        if (startIndex >= reasons.size()) {
            player.closeInventory();
            return;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            String reason2 = (String)reasons.get(i);
            ItemStack item = this.getReasonItem(reason2);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("\u00a7c" + reason2);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                meta.setLore(List.of("\u00a74Target: \u00a7c" + targetPlayer, "\u00a7aClick to submit report"));
                item.setItemMeta(meta);
                item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
            }
            gui.setItem(slots[i - startIndex], item);
        }
        if (totalPages > 1) {
            if (page < totalPages) {
                ItemStack nextButton = new ItemStack(Material.ARROW);
                ItemMeta nextMeta = nextButton.getItemMeta();
                if (nextMeta != null) {
                    nextMeta.setDisplayName("\u00a7aNext Page \u27a1");
                    nextMeta.setLore(List.of("\u00a77Click to go to the next page", String.format("\u00a77Page %d of %d", page, totalPages)));
                    nextButton.setItemMeta(nextMeta);
                }
                gui.setItem(53, nextButton);
            }
            if (page > 1) {
                ItemStack prevButton = new ItemStack(Material.ARROW);
                ItemMeta prevMeta = prevButton.getItemMeta();
                if (prevMeta != null) {
                    prevMeta.setDisplayName("\u00a7a\u2b05 Previous Page");
                    prevMeta.setLore(List.of("\u00a77Click to go to the previous page", String.format("\u00a77Page %d of %d", page, totalPages)));
                    prevButton.setItemMeta(prevMeta);
                }
                gui.setItem(45, prevButton);
            }
        }
        player.openInventory(gui);
    }

    private ItemStack getReasonItem(String reason) {
        return new ItemStack(Material.PAPER);
    }
}

