/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.listeners;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.gui.CategoryContainerGUI;
import dev.aevorinstudios.aevorinReports.gui.ReportManageGUI;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReportsContainerListener
implements Listener {
    private final BukkitPlugin plugin;

    public ReportsContainerListener(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inv = event.getInventory();
        String title = event.getView().getTitle();
        if (!(title.equals("Reports Menu") || title.endsWith("Reports") || title.startsWith("Manage Report "))) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        String display = meta.getDisplayName();
        if (display == null) {
            event.setCancelled(true);
            return;
        }
        if (display.contains("Pending Reports")) {
            event.setCancelled(true);
            List<Report> reports = this.plugin.getDatabaseManager().getReportsByStatus(Report.ReportStatus.PENDING);
            new CategoryContainerGUI(this.plugin).openCategoryGUI(player, Report.ReportStatus.PENDING, reports);
            return;
        }
        if (display.contains("Resolved Reports")) {
            event.setCancelled(true);
            List<Report> reports = this.plugin.getDatabaseManager().getReportsByStatus(Report.ReportStatus.RESOLVED);
            new CategoryContainerGUI(this.plugin).openCategoryGUI(player, Report.ReportStatus.RESOLVED, reports);
            return;
        }
        if (display.contains("Rejected Reports")) {
            event.setCancelled(true);
            List<Report> reports = this.plugin.getDatabaseManager().getReportsByStatus(Report.ReportStatus.REJECTED);
            new CategoryContainerGUI(this.plugin).openCategoryGUI(player, Report.ReportStatus.REJECTED, reports);
            return;
        }
        if (title.endsWith("Reports")) {
            event.setCancelled(true);
            if (event.getSlot() == 48 || event.getSlot() == 50) {
                Report.ReportStatus status;
                if (clicked.getType() != Material.ARROW) {
                    return;
                }
                List arrowLore = meta.getLore();
                if (arrowLore == null || arrowLore.isEmpty()) {
                    return;
                }
                String statusStr = title.substring(0, title.indexOf(" ")).toUpperCase();
                try {
                    status = Report.ReportStatus.valueOf(statusStr);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                String pageInfo = (String)arrowLore.get(0);
                if (!pageInfo.startsWith("\u00a77Go to page ")) {
                    return;
                }
                try {
                    int targetPage = Integer.parseInt(pageInfo.replace("\u00a77Go to page ", "").trim()) - 1;
                    if (targetPage < 0) {
                        return;
                    }
                    List<Report> reports = this.plugin.getDatabaseManager().getReportsByStatus(status);
                    new CategoryContainerGUI(this.plugin).openCategoryGUI(player, status, reports, targetPage);
                }
                catch (NumberFormatException targetPage) {
                    // empty catch block
                }
                return;
            }
            if (event.getSlot() < 0 || event.getSlot() >= inv.getSize()) {
                return;
            }
            List lore = meta.getLore();
            if (lore != null) {
                for (String line : lore) {
                    if (!line.startsWith("\u00a77ID: ")) continue;
                    try {
                        long reportId = Long.parseLong(line.replace("\u00a77ID: ", "").trim());
                        Report report = this.plugin.getDatabaseManager().getReport(reportId);
                        if (report == null) break;
                        player.sendMessage("\u00a77Opening management for report ID: " + reportId);
                        new ReportManageGUI(this.plugin).open(player, report);
                    }
                    catch (NumberFormatException reportId) {}
                    break;
                }
            }
            return;
        }
        if (title.startsWith("Manage Report ")) {
            event.setCancelled(true);
            int slot = event.getSlot();
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || !clickedItem.hasItemMeta()) {
                return;
            }
            ItemMeta clickedMeta = clickedItem.getItemMeta();
            String clickedName = clickedMeta.getDisplayName();
            if (slot != 45 && slot != 49 && slot != 53) {
                return;
            }
            try {
                long reportId = Long.parseLong(title.replace("Manage Report ", "").trim());
                Report report = this.plugin.getDatabaseManager().getReport(reportId);
                if (report == null) {
                    return;
                }
                if (clickedName == null) {
                    return;
                }
                if (slot == 45 && clickedName.contains("Move to Pending")) {
                    report.setStatus(Report.ReportStatus.PENDING);
                    this.plugin.getDatabaseManager().updateReport(report);
                    player.sendMessage("\u00a7eReport moved to Pending.");
                } else if (slot == 49 && clickedName.contains("Move to Resolved")) {
                    report.setStatus(Report.ReportStatus.RESOLVED);
                    this.plugin.getDatabaseManager().updateReport(report);
                    player.sendMessage("\u00a7aReport moved to Resolved.");
                } else if (slot == 53 && clickedName.contains("Move to Rejected")) {
                    report.setStatus(Report.ReportStatus.REJECTED);
                    this.plugin.getDatabaseManager().updateReport(report);
                    player.sendMessage("\u00a7cReport moved to Rejected.");
                } else {
                    return;
                }
                List<Report> updatedReports = this.plugin.getDatabaseManager().getReportsByStatus(report.getStatus());
                new CategoryContainerGUI(this.plugin).openCategoryGUI(player, report.getStatus(), updatedReports);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (title.endsWith("Reports")) {
            List lore = meta.getLore();
            if (lore != null) {
                for (String line : lore) {
                    if (!line.startsWith("\u00a77ID: ")) continue;
                    try {
                        long reportId = Long.parseLong(line.replace("\u00a77ID: ", "").trim());
                        Report report = this.plugin.getDatabaseManager().getReport(reportId);
                        if (report == null) break;
                        new ReportManageGUI(this.plugin).open(player, report);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
            event.setCancelled(true);
        }
    }
}

