/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.sync;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.utils.ExceptionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class TokenSyncManager
implements PluginMessageListener,
Listener {
    private static final String CHANNEL = "aevorinreports:sync";
    private final BukkitPlugin plugin;
    private boolean isAuthenticated = false;
    private CompletableFuture<Boolean> authFuture;
    private int authAttempts = 0;
    private static final int MAX_AUTH_ATTEMPTS = 5;
    private final Map<UUID, CompletableFuture<Boolean>> pendingMessages = new ConcurrentHashMap<UUID, CompletableFuture<Boolean>>();
    private boolean channelRegistered = false;
    private long lastSuccessfulSync = 0L;

    public TokenSyncManager(BukkitPlugin plugin) {
        this.plugin = plugin;
        this.authFuture = new CompletableFuture();
        this.setupMessaging();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.scheduleHealthCheck();
    }

    private void setupMessaging() {
        try {
            this.plugin.getLogger().info("\u269c\ufe0f Registering plugin messaging channels...");
            Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, CHANNEL);
            Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, CHANNEL, (PluginMessageListener)this);
            this.channelRegistered = true;
            this.plugin.getLogger().info("\u2705 Plugin messaging channels registered successfully!");
        }
        catch (Exception e) {
            this.channelRegistered = false;
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("channel", CHANNEL);
            ExceptionHandler.getInstance().handleException(e, "TokenSync Channel Setup", context);
            this.plugin.getLogger().severe("\u274c Failed to register plugin messaging channels!");
        }
    }

    public CompletableFuture<Boolean> authenticate() {
        boolean proxyEnabled;
        if (this.authFuture.isDone()) {
            this.authFuture = new CompletableFuture();
        }
        if (!(proxyEnabled = this.plugin.getConfig().getBoolean("proxy.enabled", false))) {
            this.plugin.getLogger().info("\u2705 Proxy synchronization is disabled in config. Authentication skipped.");
            this.authFuture.complete(true);
            return this.authFuture;
        }
        String token = this.plugin.getConfig().getString("auth.token");
        if (token == null || token.isEmpty() || token.equals("your_token_here")) {
            this.plugin.getLogger().severe("\u274c Invalid token configuration! Please set a valid token in config.yml");
            this.authFuture.complete(false);
            return this.authFuture;
        }
        if (!this.channelRegistered) {
            this.plugin.getLogger().warning("\u26a0\ufe0f Plugin messaging channels not registered. Attempting to register...");
            this.setupMessaging();
            if (!this.channelRegistered) {
                this.plugin.getLogger().severe("\u274c Failed to register plugin messaging channels. Authentication aborted.");
                this.authFuture.complete(false);
                return this.authFuture;
            }
        }
        ++this.authAttempts;
        Player player = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
        if (player != null) {
            try {
                this.plugin.getLogger().info("\ud83d\udd10 Sending authentication request to proxy via " + player.getName());
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF("AUTH");
                out.writeUTF(token);
                out.writeUTF(this.plugin.getDescription().getVersion());
                player.sendPluginMessage((Plugin)this.plugin, CHANNEL, out.toByteArray());
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (!this.authFuture.isDone()) {
                        this.plugin.getLogger().warning("\u26a0\ufe0f Authentication request timed out after 10 seconds");
                        if (this.authAttempts < 5) {
                            this.plugin.getLogger().info("\ud83d\udd04 Retrying authentication... (Attempt " + (this.authAttempts + 1) + "/5)");
                            this.authenticate();
                        } else {
                            this.plugin.getLogger().severe("\u274c Maximum authentication attempts reached. Authentication failed.");
                            this.authFuture.complete(false);
                        }
                    }
                }, 200L);
            }
            catch (Exception e) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("player", player.getName());
                context.put("attempt", this.authAttempts);
                ExceptionHandler.getInstance().handleException(e, "TokenSync Authentication", context);
                this.plugin.getLogger().severe("\u274c Failed to send authentication request!");
                this.authFuture.complete(false);
            }
        } else {
            this.plugin.getLogger().info("\u23f3 No players online. Authentication will be attempted when a player joins.");
        }
        return this.authFuture;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals(CHANNEL)) {
            return;
        }
        try {
            String subChannel;
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            switch (subChannel = in.readUTF()) {
                case "AUTH_RESPONSE": {
                    boolean success = in.readBoolean();
                    String serverName = "unknown";
                    String proxyVersion = "unknown";
                    try {
                        serverName = in.readUTF();
                        proxyVersion = in.readUTF();
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().fine("Proxy did not send additional information");
                    }
                    this.isAuthenticated = success;
                    this.authFuture.complete(success);
                    if (success) {
                        this.lastSuccessfulSync = System.currentTimeMillis();
                        this.plugin.getLogger().info(String.format("\u2705 Successfully authenticated with proxy server '%s' (version: %s)!", serverName, proxyVersion));
                        break;
                    }
                    this.plugin.getLogger().severe("\u274c Failed to authenticate with proxy. Please check your token configuration.");
                    break;
                }
                case "MESSAGE_RESPONSE": {
                    String messageId = in.readUTF();
                    boolean delivered = in.readBoolean();
                    CompletableFuture<Boolean> messageFuture = this.pendingMessages.remove(UUID.fromString(messageId));
                    if (messageFuture != null) {
                        messageFuture.complete(delivered);
                    }
                    if (delivered) {
                        this.lastSuccessfulSync = System.currentTimeMillis();
                        this.plugin.getLogger().fine("Message " + messageId + " delivered successfully");
                        break;
                    }
                    this.plugin.getLogger().warning("\u26a0\ufe0f Message " + messageId + " delivery failed");
                    break;
                }
                case "PING_RESPONSE": {
                    this.lastSuccessfulSync = System.currentTimeMillis();
                    this.plugin.getLogger().fine("Received ping response from proxy");
                    break;
                }
                default: {
                    this.plugin.getLogger().warning("\u26a0\ufe0f Received unknown subchannel: " + subChannel);
                    break;
                }
            }
        }
        catch (Exception e) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("channel", channel);
            context.put("player", player.getName());
            context.put("message_length", message.length);
            ExceptionHandler.getInstance().handleException(e, "TokenSync Message Processing", context);
            this.plugin.getLogger().log(Level.SEVERE, "\u274c Error processing plugin message", e);
        }
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public CompletableFuture<Boolean> sendMessage(String type, Map<String, String> data) {
        if (!this.isAuthenticated) {
            this.plugin.getLogger().warning("\u26a0\ufe0f Cannot send message: Not authenticated with proxy");
            return CompletableFuture.completedFuture(false);
        }
        Player player = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
        if (player == null) {
            this.plugin.getLogger().warning("\u26a0\ufe0f Cannot send message: No players online");
            return CompletableFuture.completedFuture(false);
        }
        try {
            UUID messageId = UUID.randomUUID();
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("MESSAGE");
            out.writeUTF(messageId.toString());
            out.writeUTF(type);
            out.writeInt(data.size());
            for (Map.Entry<String, String> entry : data.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
            player.sendPluginMessage((Plugin)this.plugin, CHANNEL, out.toByteArray());
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            this.pendingMessages.put(messageId, future);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                CompletableFuture<Boolean> pendingFuture = this.pendingMessages.remove(messageId);
                if (pendingFuture != null && !pendingFuture.isDone()) {
                    pendingFuture.complete(false);
                    this.plugin.getLogger().warning("\u26a0\ufe0f Message " + messageId + " delivery timed out");
                }
            }, 100L);
            return future;
        }
        catch (Exception e) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("message_type", type);
            context.put("data_size", data.size());
            ExceptionHandler.getInstance().handleException(e, "TokenSync Message Sending", context);
            this.plugin.getLogger().severe("\u274c Failed to send message to proxy!");
            return CompletableFuture.completedFuture(false);
        }
    }

    public boolean ping() {
        if (!this.isAuthenticated) {
            return false;
        }
        Player player = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
        if (player == null) {
            return false;
        }
        try {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("PING");
            out.writeLong(System.currentTimeMillis());
            player.sendPluginMessage((Plugin)this.plugin, CHANNEL, out.toByteArray());
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.getInstance().handleException(e, "TokenSync Ping");
            return false;
        }
    }

    private void scheduleHealthCheck() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long timeSinceLastSync;
            if (this.isAuthenticated && !Bukkit.getOnlinePlayers().isEmpty() && (timeSinceLastSync = System.currentTimeMillis() - this.lastSuccessfulSync) > TimeUnit.MINUTES.toMillis(5L)) {
                this.plugin.getLogger().warning("\u26a0\ufe0f No proxy communication for 5 minutes. Checking connection...");
                this.ping();
            }
        }, 6000L, 6000L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.isAuthenticated && (this.authFuture.isDone() || this.authAttempts == 0)) {
            this.plugin.getLogger().info("\ud83d\udd04 Player joined, attempting authentication with proxy...");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::authenticate, 20L);
        }
    }

    public void cleanup() {
        try {
            for (CompletableFuture<Boolean> future : this.pendingMessages.values()) {
                if (future.isDone()) continue;
                future.complete(false);
            }
            this.pendingMessages.clear();
            if (this.channelRegistered) {
                Bukkit.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, CHANNEL);
                Bukkit.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, CHANNEL, (PluginMessageListener)this);
                this.channelRegistered = false;
            }
        }
        catch (Exception e) {
            ExceptionHandler.getInstance().handleException(e, "TokenSync Cleanup");
        }
    }
}

