/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.sync;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import dev.aevorinstudios.aevorinReports.velocity.VelocityPlugin;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;

public class VelocityTokenManager {
    private static final String CHANNEL_ID = "aevorinreports:sync";
    private final MinecraftChannelIdentifier channel;
    private final VelocityPlugin plugin;
    private final ProxyServer server;
    private final String token;

    public VelocityTokenManager(VelocityPlugin plugin, ProxyServer server, String token) {
        this.plugin = plugin;
        this.server = server;
        this.token = token;
        this.channel = MinecraftChannelIdentifier.from((String)CHANNEL_ID);
        this.registerChannel();
    }

    private void registerChannel() {
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{this.channel});
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        String subChannel;
        if (!event.getIdentifier().equals(this.channel)) {
            return;
        }
        if (!(event.getSource() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getSource();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
        switch (subChannel = in.readUTF()) {
            case "AUTH": {
                this.handleAuthMessage(player, in);
                break;
            }
            case "MESSAGE": {
                this.handleReportMessage(player, in);
                break;
            }
            case "PING": {
                this.handlePingMessage(player, in);
                break;
            }
            default: {
                this.plugin.getLogger().warn("Received unknown subchannel: " + subChannel + " from server " + ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName());
            }
        }
    }

    private void handleAuthMessage(Player player, ByteArrayDataInput in) {
        try {
            String receivedToken = in.readUTF();
            String pluginVersion = "unknown";
            try {
                pluginVersion = in.readUTF();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean isValid = this.token.equals(receivedToken);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("AUTH_RESPONSE");
            out.writeBoolean(isValid);
            out.writeUTF(((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName());
            out.writeUTF(this.plugin.getClass().getPackage().getImplementationVersion() != null ? this.plugin.getClass().getPackage().getImplementationVersion() : "unknown");
            player.sendPluginMessage((ChannelIdentifier)this.channel, out.toByteArray());
            if (isValid) {
                this.plugin.getLogger().info("Server " + ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() + " (version: " + pluginVersion + ") authenticated successfully");
            } else {
                this.plugin.getLogger().warn("Failed authentication attempt from server " + ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Error processing AUTH message", e);
        }
    }

    private void handleReportMessage(Player player, ByteArrayDataInput in) {
        try {
            String messageId = in.readUTF();
            String messageType = in.readUTF();
            int dataSize = in.readInt();
            HashMap<String, String> data = new HashMap<String, String>();
            for (int i = 0; i < dataSize; ++i) {
                String key = in.readUTF();
                String value = in.readUTF();
                data.put(key, value);
            }
            boolean success = this.processReportMessage(messageType, data, player);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("MESSAGE_RESPONSE");
            out.writeUTF(messageId);
            out.writeBoolean(success);
            player.sendPluginMessage((ChannelIdentifier)this.channel, out.toByteArray());
            this.plugin.getLogger().info("Processed " + messageType + " message from " + ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() + (success ? " successfully" : " with errors"));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Error processing MESSAGE", e);
        }
    }

    private boolean processReportMessage(String messageType, Map<String, String> data, Player player) {
        try {
            this.plugin.getLogger().info("Received message type: " + messageType);
            if ("NEW_REPORT".equals(messageType)) {
                return this.handleNewReport(data, player);
            }
            this.plugin.getLogger().warn("Unknown message type: " + messageType);
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Error in processReportMessage", e);
            return false;
        }
    }

    private boolean handleNewReport(Map<String, String> data, Player player) {
        try {
            this.plugin.getLogger().info("Processing new report from server: " + ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName());
            long reportId = Long.parseLong(data.get("id"));
            String reporterUuid = data.get("reporter_uuid");
            String reporterName = data.get("reporter_name");
            String reportedUuid = data.get("reported_uuid");
            String reportedName = data.get("reported_name");
            String reason = data.get("reason");
            String serverName = data.get("server_name");
            String status = data.get("status");
            this.server.getAllPlayers().forEach(staffPlayer -> {
                if (staffPlayer.hasPermission("aevorinreports.notify")) {
                    staffPlayer.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("[Reports] ").color(NamedTextColor.RED)).append(Component.text(reporterName).color(NamedTextColor.RED))).append(Component.text(" has reported ").color(NamedTextColor.WHITE))).append(Component.text(reportedName).color(NamedTextColor.YELLOW))).append(Component.text(" for: ").color(NamedTextColor.WHITE))).append(Component.text(reason).color(NamedTextColor.YELLOW))).append(Component.text(" on server: ").color(NamedTextColor.WHITE))).append(Component.text(serverName).color(NamedTextColor.AQUA))).build());
                }
            });
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Error processing new report", e);
            return false;
        }
    }

    private void handlePingMessage(Player player, ByteArrayDataInput in) {
        try {
            long timestamp = 0L;
            try {
                timestamp = in.readLong();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("PING_RESPONSE");
            out.writeLong(System.currentTimeMillis());
            player.sendPluginMessage((ChannelIdentifier)this.channel, out.toByteArray());
            this.plugin.getLogger().info("Ping received from " + ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Error processing PING message", e);
        }
    }

    public void cleanup() {
        this.server.getChannelRegistrar().unregister(new ChannelIdentifier[]{this.channel});
    }
}

