/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.utils;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinreports.libs.gson.JsonObject;
import dev.aevorinstudios.aevorinreports.libs.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ModrinthUpdateChecker
implements Listener {
    private final BukkitPlugin plugin;
    private final String projectId;
    private String latestVersion;
    private String downloadUrl;
    private boolean updateAvailable = false;

    public ModrinthUpdateChecker(BukkitPlugin plugin, String projectId) {
        this.plugin = plugin;
        this.projectId = projectId;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void checkUpdate() {
        block6: {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/" + this.projectId + "/version");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", "AevorinReports/" + this.plugin.getDescription().getVersion());
                if (conn.getResponseCode() == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    JsonObject[] versions = (JsonObject[])JsonParser.parseString(response.toString()).getAsJsonArray().asList().stream().map(element -> element.getAsJsonObject()).toArray(JsonObject[]::new);
                    if (versions.length > 0) {
                        JsonObject latest = versions[0];
                        this.latestVersion = latest.get("version_number").getAsString();
                        this.downloadUrl = latest.getAsJsonArray("files").get(0).getAsJsonObject().get("url").getAsString();
                        String currentVersion = this.plugin.getDescription().getVersion();
                        boolean bl = this.updateAvailable = !currentVersion.equals(this.latestVersion);
                        if (this.updateAvailable) {
                            this.plugin.getLogger().info("A new version of AevorinReports is available: " + this.latestVersion);
                            this.plugin.getLogger().info("Download it from: " + this.downloadUrl);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
                if (!this.plugin.getConfig().getBoolean("debug.enabled", false)) break block6;
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.updateAvailable && player.hasPermission("aevorinreports.update") && this.plugin.getConfig().getBoolean("update-checker.notify-on-join", true)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                String prefix = this.plugin.getConfig().getString("notifications.prefix", "&8[&bAevorinReports&8]&r ");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&eA new version is available: &b" + this.latestVersion)));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&eDownload it from: &b" + this.downloadUrl)));
            }, 40L);
        }
    }

    public void startUpdateChecker() {
        long interval = this.plugin.getConfig().getLong("update-checker.check-interval", 60L);
        this.checkUpdate();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::checkUpdate, TimeUnit.MINUTES.toSeconds(interval) * 20L, TimeUnit.MINUTES.toSeconds(interval) * 20L);
    }
}

