/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.aevorinstudios.aevorinReports.config.VelocityConfigManager;
import dev.aevorinstudios.aevorinReports.database.DatabaseManager;
import dev.aevorinstudios.aevorinReports.sync.VelocityTokenManager;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;

@Plugin(id="aevorinreports", name="AevorinReports", version="1.0.3", description="A comprehensive reporting system for Minecraft servers", authors={"borhani", "Aiversity"})
public class VelocityPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private DatabaseManager databaseManager;
    private VelocityTokenManager tokenManager;
    private VelocityConfigManager configManager;

    @Inject
    public VelocityPlugin(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        try {
            this.configManager = new VelocityConfigManager(this.dataDirectory);
            this.configManager.loadConfig();
            this.logger.info("Configuration loaded successfully. Token: " + this.configManager.getToken());
        }
        catch (IOException e) {
            this.logger.error("Failed to load configuration", e);
            return;
        }
        this.initializeDatabase();
        this.registerCommands();
        this.registerListeners();
        this.tokenManager = new VelocityTokenManager(this, this.server, this.configManager.getToken());
        this.server.getEventManager().register((Object)this, (Object)this.tokenManager);
        this.logger.info("AevorinReports has been enabled!");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void onDisable() {
        if (this.tokenManager != null) {
            this.tokenManager.cleanup();
        }
    }

    private void initializeDatabase() {
    }

    private void registerCommands() {
    }

    private void registerListeners() {
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }
}

