/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.database.DatabaseManager;
import dev.aevorinstudios.aevorinReports.gui.ReportReasonContainerGUI;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitReportCommand
implements CommandExecutor,
TabCompleter {
    private final BukkitPlugin plugin;

    public BukkitReportCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.report")) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(ChatColor.RED + "Usage: /report <player> [reason]");
            return true;
        }
        String targetPlayer = args[0];
        Player target = this.plugin.getServer().getPlayer(targetPlayer);
        if (target == null) {
            player.sendMessage(ChatColor.RED + "Player not found!");
            return true;
        }
        boolean allowSelfReporting = this.plugin.getConfig().getBoolean("reports.allow-self-reporting", true);
        if (!allowSelfReporting && player.getName().equalsIgnoreCase(targetPlayer)) {
            player.sendMessage(ChatColor.RED + "You cannot report yourself.");
            return true;
        }
        if (args.length > 1) {
            String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            if (reason.equalsIgnoreCase("custom")) {
                if (!this.plugin.getConfig().getBoolean("reports.allow-custom-reasons", true)) {
                    player.sendMessage(ChatColor.RED + this.plugin.getConfig().getString("messages.custom-reason-disabled", "Custom reasons are disabled."));
                    return true;
                }
                this.plugin.getCustomReasonHandler().startCustomReason(player, targetPlayer);
                player.sendMessage(ChatColor.GREEN + this.plugin.getConfig().getString("messages.enter-custom-reason", "Please enter your reason in the chat:"));
                return true;
            }
            this.createReport(player, targetPlayer, reason);
            return true;
        }
        this.showReportCategories(player, target.getName());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player) || !sender.hasPermission("aevorinreports.report")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            ArrayList<String> playerNames = new ArrayList<String>();
            String partialName = args[0].toLowerCase();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(partialName)) continue;
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>(this.plugin.getConfig().getStringList("reports.categories"));
            if (this.plugin.getConfig().getBoolean("reports.allow-custom-reasons", true)) {
                suggestions.add("custom");
            }
            String partialReason = args[1].toLowerCase();
            return suggestions.stream().filter(reason -> reason.toLowerCase().startsWith(partialReason)).toList();
        }
        return new ArrayList<String>();
    }

    public void createReport(Player reporter, String targetPlayer, String category) {
        LocalDateTime now = LocalDateTime.now();
        Report report = Report.builder().reporterUuid(reporter.getUniqueId()).reportedUuid(this.plugin.getServer().getOfflinePlayer(targetPlayer).getUniqueId()).reason(category).serverName(this.plugin.getServer().getName()).status(Report.ReportStatus.PENDING).isAnonymous(false).createdAt(now).updatedAt(now).build();
        DatabaseManager.getInstance().saveReport(report);
        for (Player staff : this.plugin.getServer().getOnlinePlayers()) {
            if (!staff.hasPermission("aevorinreports.notify")) continue;
            staff.sendMessage(ChatColor.RED + "[Reports] " + ChatColor.RED + reporter.getName() + ChatColor.WHITE + " has reported " + ChatColor.YELLOW + targetPlayer + ChatColor.WHITE + " for: " + ChatColor.YELLOW + category);
        }
        if (this.plugin.getConfig().getBoolean("proxy.enabled", false) && this.plugin.getTokenSyncManager() != null && this.plugin.getTokenSyncManager().isAuthenticated()) {
            HashMap<String, String> reportData = new HashMap<String, String>();
            reportData.put("id", String.valueOf(report.getId()));
            reportData.put("reporter_uuid", report.getReporterUuid().toString());
            reportData.put("reporter_name", reporter.getName());
            reportData.put("reported_uuid", report.getReportedUuid().toString());
            reportData.put("reported_name", targetPlayer);
            reportData.put("reason", report.getReason());
            reportData.put("server_name", report.getServerName());
            reportData.put("status", report.getStatus().toString());
            reportData.put("created_at", report.getCreatedAt().toString());
            this.plugin.getTokenSyncManager().sendMessage("NEW_REPORT", reportData).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.plugin.getLogger().info("Report #" + report.getId() + " successfully synced with proxy");
                } else {
                    this.plugin.getLogger().warning("Failed to sync report #" + report.getId() + " with proxy");
                }
            });
        }
        reporter.sendMessage(ChatColor.GREEN + "Your report has been submitted successfully!");
    }

    private void showReportCategories(Player player, String targetPlayer) {
        String guiType = this.plugin.getConfig().getString("reports.gui.type", "book");
        if (guiType.equalsIgnoreCase("container")) {
            new ReportReasonContainerGUI(this.plugin).showReasonContainerGUI(player, targetPlayer);
        } else {
            this.showReportBookGUI(player, targetPlayer);
        }
    }

    private void showReportBookGUI(Player player, String targetPlayer) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.setTitle(ChatColor.GOLD + "Report Player");
        meta.setAuthor("Server Admin");
        ArrayList<String> categories = this.plugin.getConfig().getStringList("reports.categories");
        if (categories.isEmpty()) {
            categories = new ArrayList<String>(List.of("Hacking/Cheating", "Harassment/Bullying", "Inappropriate Language", "Spam/Advertisement", "Griefing/Vandalism", "Other"));
        }
        ArrayList<BaseComponent[]> pages = new ArrayList<BaseComponent[]>();
        ComponentBuilder currentBuilder = new ComponentBuilder();
        currentBuilder.append(ChatColor.DARK_RED + "Reporting player:\n").append(ChatColor.RED + targetPlayer + "\n\n").append(ChatColor.DARK_RED + "Select a reason:\n" + ChatColor.GRAY + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\n");
        String commandPrefix = "/report-category";
        int headerLines = 5;
        int maxLinesPerPage = 12;
        int firstPageCategories = maxLinesPerPage - headerLines - 2;
        int subsequentPageCategories = maxLinesPerPage - 3 - 2;
        int totalPages = 1;
        int remainingCategories = categories.size();
        if (remainingCategories > firstPageCategories) {
            totalPages += (int)Math.ceil((double)(remainingCategories -= firstPageCategories) / (double)subsequentPageCategories);
        }
        int currentPageCategories = 0;
        boolean isFirstPage = true;
        int currentPage = 1;
        for (String category : categories) {
            int maxCategoriesForCurrentPage;
            int n = maxCategoriesForCurrentPage = isFirstPage ? firstPageCategories : subsequentPageCategories;
            if (currentPageCategories >= maxCategoriesForCurrentPage) {
                currentBuilder.append("\n" + ChatColor.GRAY + "Page " + currentPage + " of " + totalPages);
                pages.add(currentBuilder.create());
                currentBuilder = new ComponentBuilder().append(ChatColor.GRAY + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\n");
                currentPageCategories = 0;
                isFirstPage = false;
                ++currentPage;
            }
            TextComponent categoryComponent = new TextComponent();
            categoryComponent.addExtra((BaseComponent)new TextComponent(ChatColor.RED + "\u2022 "));
            TextComponent categoryText = new TextComponent(category);
            categoryText.setColor(ChatColor.RED);
            categoryText.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/report " + targetPlayer + " " + category));
            categoryText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to report for " + category).create()));
            categoryComponent.addExtra((BaseComponent)categoryText);
            categoryComponent.addExtra("\n");
            currentBuilder.append((BaseComponent)categoryComponent);
            ++currentPageCategories;
        }
        if (this.plugin.getConfig().getBoolean("reports.allow-custom-reasons", true)) {
            if (currentPageCategories >= (isFirstPage ? firstPageCategories : subsequentPageCategories)) {
                currentBuilder.append("\n" + ChatColor.GRAY + "Page " + currentPage + " of " + totalPages);
                pages.add(currentBuilder.create());
                currentBuilder = new ComponentBuilder().append(ChatColor.GRAY + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\n");
                currentPageCategories = 0;
                isFirstPage = false;
                ++currentPage;
            }
            TextComponent customComponent = new TextComponent();
            customComponent.addExtra((BaseComponent)new TextComponent(ChatColor.RED + "\u2022 "));
            TextComponent customText = new TextComponent("Custom Reason");
            customText.setColor(ChatColor.RED);
            customText.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/report " + targetPlayer + " custom"));
            customText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to enter a custom reason").create()));
            customComponent.addExtra((BaseComponent)customText);
            customComponent.addExtra("\n");
            currentBuilder.append((BaseComponent)customComponent);
            ++currentPageCategories;
        }
        currentBuilder.append("\n" + ChatColor.GRAY + "Page " + currentPage + " of " + totalPages);
        pages.add(currentBuilder.create());
        try {
            if (!pages.isEmpty()) {
                int i;
                for (i = 0; i < pages.size(); ++i) {
                    meta.addPage(new String[]{""});
                }
                book.setItemMeta((ItemMeta)meta);
                meta = (BookMeta)book.getItemMeta();
                for (i = 0; i < pages.size(); ++i) {
                    meta.spigot().setPage(i + 1, (BaseComponent[])pages.get(i));
                }
                book.setItemMeta((ItemMeta)meta);
                player.openBook(book);
            } else {
                player.sendMessage(ChatColor.RED + "No report categories available.");
            }
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + "An error occurred while creating the report menu.");
            this.plugin.getLogger().warning("Error creating report book GUI: " + e.getMessage());
        }
    }
}

