/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.config;

import dev.aevorinstudios.aevorinreports.libs.gson.Gson;
import dev.aevorinstudios.aevorinreports.libs.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static volatile ConfigManager instance;
    private static final ReentrantReadWriteLock configLock;
    private final Path configPath;
    private Config config;

    private ConfigManager(Path dataDirectory) {
        this.configPath = dataDirectory.resolve("config.yml");
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigManager initialize(Path dataDirectory) {
        if (instance != null) return instance;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (instance != null) return instance;
            instance = new ConfigManager(dataDirectory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ConfigManager has not been initialized. Call initialize() first.");
        }
        return instance;
    }

    private Config convertYamlToConfig(Map<String, Object> yamlConfig) {
        Map notifications;
        Map security;
        Map reports;
        Map db;
        Config config = new Config();
        if (yamlConfig == null) {
            return config;
        }
        if (yamlConfig.containsKey("auth")) {
            Map authRaw = (Map)yamlConfig.get("auth");
            HashMap auth = new HashMap();
            if (authRaw != null) {
                for (Map.Entry entry : authRaw.entrySet()) {
                    auth.put(String.valueOf(entry.getKey()), entry.getValue());
                }
            }
            if (!auth.isEmpty()) {
                config.getAuth().setToken(auth.getOrDefault("token", ""));
                config.getAuth().setRegenerateToken(auth.getOrDefault("regenerateToken", false));
            }
        }
        if (yamlConfig.containsKey("database") && (db = (Map)yamlConfig.get("database")) != null) {
            Map file;
            Map mysql;
            config.getDatabase().setType(db.getOrDefault("type", "file"));
            if (db.containsKey("mysql") && (mysql = (Map)db.get("mysql")) != null) {
                config.getDatabase().getMysql().setHost(mysql.getOrDefault("host", "localhost"));
                config.getDatabase().getMysql().setPort(Integer.parseInt(String.valueOf(mysql.getOrDefault("port", 3306))));
                config.getDatabase().getMysql().setDatabase(mysql.getOrDefault("database", "aevorinreports"));
                config.getDatabase().getMysql().setUsername(mysql.getOrDefault("username", "root"));
                config.getDatabase().getMysql().setPassword(mysql.getOrDefault("password", ""));
            }
            if (db.containsKey("file") && (file = (Map)db.get("file")) != null) {
                config.getDatabase().getFile().setPath(file.getOrDefault("path", "database/reports.db"));
            }
        }
        if (yamlConfig.containsKey("reports") && (reports = (Map)yamlConfig.get("reports")) != null) {
            config.getReports().setCooldownSeconds(reports.getOrDefault("cooldownSeconds", 300));
            config.getReports().setAllowAnonymousReports(reports.getOrDefault("allowAnonymousReports", true));
            config.getReports().setMaxActiveReportsPerPlayer(reports.getOrDefault("maxActiveReportsPerPlayer", 3));
            config.getReports().setChatHistoryLines(reports.getOrDefault("chatHistoryLines", 50));
            config.getReports().setLogInventory(reports.getOrDefault("logInventory", true));
            config.getReports().setLogLocation(reports.getOrDefault("logLocation", true));
        }
        if (yamlConfig.containsKey("security") && (security = (Map)yamlConfig.get("security")) != null) {
            config.getSecurity().setMaxFalseReports(Integer.parseInt(String.valueOf(security.getOrDefault("maxFalseReports", 5))));
            config.getSecurity().setFalseReportBanHours(security.getOrDefault("falseReportBanHours", 24));
            config.getSecurity().setMaxReportsBeforeFlag(security.getOrDefault("maxReportsBeforeFlag", 10));
            config.getSecurity().setEncryptionKey(security.getOrDefault("encryptionKey", ""));
            config.getSecurity().setEnableTokenAuth(security.getOrDefault("enableTokenAuth", true));
        }
        if (yamlConfig.containsKey("notifications") && (notifications = (Map)yamlConfig.get("notifications")) != null) {
            config.getNotifications().setEnableChatNotifications(notifications.getOrDefault("enableChatNotifications", true));
            config.getNotifications().setEnableTitleNotifications(notifications.getOrDefault("enableTitleNotifications", true));
            config.getNotifications().setEnableSoundNotifications(notifications.getOrDefault("enableSoundNotifications", true));
            config.getNotifications().setNotificationSound(notifications.getOrDefault("notificationSound", "BLOCK_NOTE_BLOCK_PLING"));
        }
        if (yamlConfig.containsKey("customReasons")) {
            Map customReasonsRaw = (Map)yamlConfig.get("customReasons");
            HashMap<String, String> customReasons = new HashMap<String, String>();
            if (customReasonsRaw != null) {
                for (Map.Entry entry : customReasonsRaw.entrySet()) {
                    customReasons.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
                config.setCustomReasons(new HashMap<String, String>(customReasons));
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        configLock.writeLock().lock();
        try {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                logger.info("Configuration file not found, creating default config.yml");
                this.config = this.createDefaultConfig();
                this.saveConfig();
                return;
            }
            logger.info("Loading configuration from {}", (Object)this.configPath);
            try (InputStream inputStream = Files.newInputStream(this.configPath, new OpenOption[0]);){
                LoaderOptions loaderOptions = new LoaderOptions();
                loaderOptions.setAllowDuplicateKeys(false);
                loaderOptions.setMaxAliasesForCollections(50);
                Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(loaderOptions));
                Object loadedYaml = yaml.load(inputStream);
                if (!(loadedYaml instanceof Map)) {
                    throw new IllegalStateException("Invalid configuration format: Root element must be a mapping");
                }
                Map yamlConfig = (Map)loadedYaml;
                try {
                    this.config = this.convertYamlToConfig(yamlConfig);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to convert configuration: " + e.getMessage(), e);
                }
                try {
                    this.validateConfiguration();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Configuration validation failed: " + e.getMessage(), e);
                }
                if (this.config.getSecurity().getEncryptionKey().isEmpty()) {
                    this.config.getSecurity().setEncryptionKey(this.generateSecureKey());
                    this.saveConfig();
                }
                logger.info("Configuration loaded successfully");
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read configuration file: " + e.getMessage(), e);
            }
        }
        catch (IllegalStateException e) {
            logger.error("Configuration error: {}", (Object)e.getMessage(), (Object)e);
            logger.warn("Loading default configuration");
            this.config = this.createDefaultConfig();
            this.config.getSecurity().setEncryptionKey(this.generateSecureKey());
            try {
                this.saveConfig();
            }
            catch (Exception ex) {
                logger.error("Failed to save default configuration: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    private String generateSecureKey() {
        byte[] key = new byte[48];
        new SecureRandom().nextBytes(key);
        return Base64.getEncoder().encodeToString(key);
    }

    public Config getConfig() {
        configLock.readLock().lock();
        try {
            Config config = this.config;
            return config;
        }
        finally {
            configLock.readLock().unlock();
        }
    }

    private Config createDefaultConfig() {
        Config defaultConfig = new Config();
        defaultConfig.getSecurity().setEncryptionKey(this.generateSecureKey());
        return defaultConfig;
    }

    private void validateConfiguration() throws IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("Configuration not loaded");
        }
        if (this.config.getSecurity().getEncryptionKey() == null || this.config.getSecurity().getEncryptionKey().isEmpty() || this.config.getSecurity().getEncryptionKey().length() < 32) {
            logger.warn("Encryption key missing or too short, generating a new secure key");
            this.config.getSecurity().setEncryptionKey(this.generateSecureKey());
        }
        if (this.config.getDatabase().getType().equals("mysql") && (this.config.getDatabase().getMysql().getPassword().isEmpty() || this.config.getDatabase().getMysql().getUsername().isEmpty())) {
            throw new IllegalStateException("MySQL credentials must be provided");
        }
        this.validateDatabaseConfig();
        this.validateSecurityConfig();
        this.validatePerformanceConfig();
        this.validateReportsConfig();
    }

    private void validateDatabaseConfig() {
        Config.DatabaseConfig.MySQLConfig mysql;
        Config.DatabaseConfig db = this.config.getDatabase();
        if (!"mysql".equals(db.getType()) && !"file".equals(db.getType())) {
            logger.warn("Invalid database type '{}', defaulting to 'file'", (Object)db.getType());
            db.setType("file");
        }
        if ("mysql".equals(db.getType()) && ((mysql = db.getMysql()).getPort() <= 0 || mysql.getPort() > 65535)) {
            logger.warn("Invalid MySQL port {}, defaulting to 3306", (Object)mysql.getPort());
            mysql.setPort(3306);
        }
    }

    private void validateSecurityConfig() {
        Config.SecurityConfig security = this.config.getSecurity();
        if (security.getMaxFalseReports() < 0) {
            logger.warn("Invalid maxFalseReports value, setting to default");
            security.setMaxFalseReports(5);
        }
        if (security.getFalseReportBanHours() < 0) {
            logger.warn("Invalid falseReportBanHours value, setting to default");
            security.setFalseReportBanHours(24);
        }
        if (security.getMaxReportsBeforeFlag() < 0) {
            logger.warn("Invalid maxReportsBeforeFlag value, setting to default");
            security.setMaxReportsBeforeFlag(10);
        }
    }

    private void validatePerformanceConfig() {
        Config.PerformanceConfig performance = this.config.getPerformance();
        if (performance.getCacheDuration() < 0) {
            logger.warn("Invalid cacheDuration value, setting to default");
            performance.setCacheDuration(15);
        }
        if (performance.getMaxCacheSize() < 0) {
            logger.warn("Invalid maxCacheSize value, setting to default");
            performance.setMaxCacheSize(1000);
        }
        if (performance.getBatchSize() < 1) {
            logger.warn("Invalid batchSize value, setting to default");
            performance.setBatchSize(50);
        }
        if (performance.getBackgroundTaskInterval() < 0) {
            logger.warn("Invalid backgroundTaskInterval value, setting to default");
            performance.setBackgroundTaskInterval(300);
        }
        if (performance.getCacheCleanupInterval() < 0) {
            logger.warn("Invalid cacheCleanupInterval value, setting to default");
            performance.setCacheCleanupInterval(30);
        }
    }

    private void validateReportsConfig() {
        Config.ReportsConfig reports = this.config.getReports();
        if (reports.getCooldownSeconds() < 0) {
            logger.warn("Invalid cooldownSeconds value, setting to default");
            reports.setCooldownSeconds(300);
        }
        if (reports.getMaxActiveReportsPerPlayer() < 1) {
            logger.warn("Invalid maxActiveReportsPerPlayer value, setting to default");
            reports.setMaxActiveReportsPerPlayer(3);
        }
        if (reports.getChatHistoryLines() < 0) {
            logger.warn("Invalid chatHistoryLines value, setting to default");
            reports.setChatHistoryLines(50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        configLock.writeLock().lock();
        try {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            Yaml yaml = new Yaml(options);
            Map<String, Object> configMap = this.convertConfigToYaml();
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.writeString(this.configPath, (CharSequence)yaml.dump(configMap), new OpenOption[0]);
            logger.info("Configuration saved successfully to {}", (Object)this.configPath);
        }
        catch (IOException e) {
            logger.error("Failed to save configuration: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    private Map<String, Object> convertConfigToYaml() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> auth = new HashMap<String, Object>();
        auth.put("token", this.config.getAuth().getToken());
        auth.put("regenerateToken", this.config.getAuth().isRegenerateToken());
        result.put("auth", auth);
        HashMap<String, Object> database = new HashMap<String, Object>();
        database.put("type", this.config.getDatabase().getType());
        HashMap<String, Object> mysql = new HashMap<String, Object>();
        mysql.put("host", this.config.getDatabase().getMysql().getHost());
        mysql.put("port", this.config.getDatabase().getMysql().getPort());
        mysql.put("database", this.config.getDatabase().getMysql().getDatabase());
        mysql.put("username", this.config.getDatabase().getMysql().getUsername());
        mysql.put("password", this.config.getDatabase().getMysql().getPassword());
        database.put("mysql", mysql);
        HashMap<String, String> file = new HashMap<String, String>();
        file.put("path", this.config.getDatabase().getFile().getPath());
        database.put("file", file);
        result.put("database", database);
        HashMap<String, Constable> reports = new HashMap<String, Constable>();
        reports.put("cooldownSeconds", Integer.valueOf(this.config.getReports().getCooldownSeconds()));
        reports.put("allowAnonymousReports", Boolean.valueOf(this.config.getReports().isAllowAnonymousReports()));
        reports.put("maxActiveReportsPerPlayer", Integer.valueOf(this.config.getReports().getMaxActiveReportsPerPlayer()));
        reports.put("chatHistoryLines", Integer.valueOf(this.config.getReports().getChatHistoryLines()));
        reports.put("logInventory", Boolean.valueOf(this.config.getReports().isLogInventory()));
        reports.put("logLocation", Boolean.valueOf(this.config.getReports().isLogLocation()));
        result.put("reports", reports);
        HashMap<String, Object> security = new HashMap<String, Object>();
        security.put("maxFalseReports", this.config.getSecurity().getMaxFalseReports());
        security.put("falseReportBanHours", this.config.getSecurity().getFalseReportBanHours());
        security.put("maxReportsBeforeFlag", this.config.getSecurity().getMaxReportsBeforeFlag());
        security.put("encryptionKey", this.config.getSecurity().getEncryptionKey());
        security.put("enableTokenAuth", this.config.getSecurity().isEnableTokenAuth());
        result.put("security", security);
        HashMap<String, Object> notifications = new HashMap<String, Object>();
        notifications.put("enableChatNotifications", this.config.getNotifications().isEnableChatNotifications());
        notifications.put("enableTitleNotifications", this.config.getNotifications().isEnableTitleNotifications());
        notifications.put("enableSoundNotifications", this.config.getNotifications().isEnableSoundNotifications());
        notifications.put("notificationSound", this.config.getNotifications().getNotificationSound());
        result.put("notifications", notifications);
        HashMap<String, Comparable<Boolean>> performance = new HashMap<String, Comparable<Boolean>>();
        performance.put("enableCaching", Boolean.valueOf(this.config.getPerformance().isEnableCaching()));
        performance.put("cacheDuration", Integer.valueOf(this.config.getPerformance().getCacheDuration()));
        performance.put("maxCacheSize", Integer.valueOf(this.config.getPerformance().getMaxCacheSize()));
        performance.put("asyncProcessing", Boolean.valueOf(this.config.getPerformance().isAsyncProcessing()));
        performance.put("batchSize", Integer.valueOf(this.config.getPerformance().getBatchSize()));
        performance.put("backgroundTaskInterval", Integer.valueOf(this.config.getPerformance().getBackgroundTaskInterval()));
        performance.put("cacheCleanupInterval", Integer.valueOf(this.config.getPerformance().getCacheCleanupInterval()));
        result.put("performance", performance);
        if (this.config.getCustomReasons() != null) {
            result.put("customReasons", new HashMap<String, String>(this.config.getCustomReasons()));
        }
        return result;
    }

    @Nullable
    public String getMessage(String key) {
        if (key == null) {
            return "";
        }
        HashMap<String, String> defaultMessages = new HashMap<String, String>();
        defaultMessages.put("messages.book.main-title", "Report Management");
        defaultMessages.put("messages.book.group-title", "Reports: {status}");
        defaultMessages.put("messages.book.view-details", "Click to view details");
        defaultMessages.put("messages.book.view-group", "View {count} {status} reports");
        defaultMessages.put("messages.errors.no-reports", "No {status} reports found.");
        defaultMessages.put("messages.errors.book-meta-null", "Error creating book.");
        defaultMessages.put("messages.errors.player-only", "This command is for players only.");
        defaultMessages.put("messages.errors.no-permission", "You don't have permission to use this command.");
        defaultMessages.put("messages.errors.invalid-group", "Invalid report status group.");
        return defaultMessages.getOrDefault(key, "");
    }

    public String getSymbol(String symbolKey) {
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put("group_bullet", "\u2022 ");
        return symbols.getOrDefault(symbolKey, "");
    }

    public String getSeparator() {
        return "------------------------";
    }

    @NotNull
    public String getFormattedMessage(String messageKey, String placeholder1, String value1, String placeholder2, String value2) {
        String message = this.getMessage(messageKey);
        if (message == null || message.isEmpty()) {
            return "Message not found: " + messageKey;
        }
        if (placeholder1 != null && value1 != null) {
            message = message.replace(placeholder1, value1);
        }
        if (placeholder2 != null && value2 != null) {
            message = message.replace(placeholder2, value2);
        }
        return message;
    }

    public int getReportsPerPage() {
        return 5;
    }

    @NotNull
    public Style getStatusColor(String statusName) {
        if (statusName == null) {
            return Style.empty();
        }
        switch (statusName.toUpperCase()) {
            case "PENDING": {
                return Style.style(NamedTextColor.GOLD);
            }
            case "IN_PROGRESS": {
                return Style.style(NamedTextColor.YELLOW);
            }
            case "RESOLVED": {
                return Style.style(NamedTextColor.GREEN);
            }
            case "REJECTED": {
                return Style.style(NamedTextColor.RED);
            }
        }
        return Style.style(NamedTextColor.GRAY);
    }

    public String getText(String key) {
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("messages.report-format.number-prefix", "#");
        textMap.put("gui.spacing.after_number", ": ");
        return textMap.getOrDefault(key, "");
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigManager)) {
            return false;
        }
        ConfigManager other = (ConfigManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$configPath = this.getConfigPath();
        Path other$configPath = other.getConfigPath();
        if (this$configPath == null ? other$configPath != null : !((Object)this$configPath).equals(other$configPath)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $configPath = this.getConfigPath();
        result = result * 59 + ($configPath == null ? 43 : ((Object)$configPath).hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigManager(configPath=" + this.getConfigPath() + ", config=" + this.getConfig() + ")";
    }

    static {
        configLock = new ReentrantReadWriteLock();
    }

    public static class Config {
        private AuthConfig auth = new AuthConfig();
        private DatabaseConfig database = new DatabaseConfig();
        private ReportsConfig reports = new ReportsConfig();
        private SecurityConfig security = new SecurityConfig();
        private NotificationsConfig notifications = new NotificationsConfig();
        private PerformanceConfig performance = new PerformanceConfig();
        private Map<String, String> customReasons = new HashMap<String, String>();

        public AuthConfig getAuth() {
            return this.auth;
        }

        public DatabaseConfig getDatabase() {
            return this.database;
        }

        public ReportsConfig getReports() {
            return this.reports;
        }

        public SecurityConfig getSecurity() {
            return this.security;
        }

        public NotificationsConfig getNotifications() {
            return this.notifications;
        }

        public PerformanceConfig getPerformance() {
            return this.performance;
        }

        public Map<String, String> getCustomReasons() {
            return this.customReasons;
        }

        public void setAuth(AuthConfig auth) {
            this.auth = auth;
        }

        public void setDatabase(DatabaseConfig database) {
            this.database = database;
        }

        public void setReports(ReportsConfig reports) {
            this.reports = reports;
        }

        public void setSecurity(SecurityConfig security) {
            this.security = security;
        }

        public void setNotifications(NotificationsConfig notifications) {
            this.notifications = notifications;
        }

        public void setPerformance(PerformanceConfig performance) {
            this.performance = performance;
        }

        public void setCustomReasons(Map<String, String> customReasons) {
            this.customReasons = customReasons;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AuthConfig this$auth = this.getAuth();
            AuthConfig other$auth = other.getAuth();
            if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
                return false;
            }
            DatabaseConfig this$database = this.getDatabase();
            DatabaseConfig other$database = other.getDatabase();
            if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
                return false;
            }
            ReportsConfig this$reports = this.getReports();
            ReportsConfig other$reports = other.getReports();
            if (this$reports == null ? other$reports != null : !((Object)this$reports).equals(other$reports)) {
                return false;
            }
            SecurityConfig this$security = this.getSecurity();
            SecurityConfig other$security = other.getSecurity();
            if (this$security == null ? other$security != null : !((Object)this$security).equals(other$security)) {
                return false;
            }
            NotificationsConfig this$notifications = this.getNotifications();
            NotificationsConfig other$notifications = other.getNotifications();
            if (this$notifications == null ? other$notifications != null : !((Object)this$notifications).equals(other$notifications)) {
                return false;
            }
            PerformanceConfig this$performance = this.getPerformance();
            PerformanceConfig other$performance = other.getPerformance();
            if (this$performance == null ? other$performance != null : !((Object)this$performance).equals(other$performance)) {
                return false;
            }
            Map<String, String> this$customReasons = this.getCustomReasons();
            Map<String, String> other$customReasons = other.getCustomReasons();
            return !(this$customReasons == null ? other$customReasons != null : !((Object)this$customReasons).equals(other$customReasons));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AuthConfig $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
            DatabaseConfig $database = this.getDatabase();
            result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
            ReportsConfig $reports = this.getReports();
            result = result * 59 + ($reports == null ? 43 : ((Object)$reports).hashCode());
            SecurityConfig $security = this.getSecurity();
            result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
            NotificationsConfig $notifications = this.getNotifications();
            result = result * 59 + ($notifications == null ? 43 : ((Object)$notifications).hashCode());
            PerformanceConfig $performance = this.getPerformance();
            result = result * 59 + ($performance == null ? 43 : ((Object)$performance).hashCode());
            Map<String, String> $customReasons = this.getCustomReasons();
            result = result * 59 + ($customReasons == null ? 43 : ((Object)$customReasons).hashCode());
            return result;
        }

        public String toString() {
            return "ConfigManager.Config(auth=" + this.getAuth() + ", database=" + this.getDatabase() + ", reports=" + this.getReports() + ", security=" + this.getSecurity() + ", notifications=" + this.getNotifications() + ", performance=" + this.getPerformance() + ", customReasons=" + this.getCustomReasons() + ")";
        }

        public static class AuthConfig {
            private String token = "";
            private boolean regenerateToken = false;

            public String getToken() {
                return this.token;
            }

            public boolean isRegenerateToken() {
                return this.regenerateToken;
            }

            public void setToken(String token) {
                this.token = token;
            }

            public void setRegenerateToken(boolean regenerateToken) {
                this.regenerateToken = regenerateToken;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuthConfig)) {
                    return false;
                }
                AuthConfig other = (AuthConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isRegenerateToken() != other.isRegenerateToken()) {
                    return false;
                }
                String this$token = this.getToken();
                String other$token = other.getToken();
                return !(this$token == null ? other$token != null : !this$token.equals(other$token));
            }

            protected boolean canEqual(Object other) {
                return other instanceof AuthConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isRegenerateToken() ? 79 : 97);
                String $token = this.getToken();
                result = result * 59 + ($token == null ? 43 : $token.hashCode());
                return result;
            }

            public String toString() {
                return "ConfigManager.Config.AuthConfig(token=" + this.getToken() + ", regenerateToken=" + this.isRegenerateToken() + ")";
            }
        }

        public static class DatabaseConfig {
            private String type = "file";
            private MySQLConfig mysql = new MySQLConfig();
            private FileStorageConfig file = new FileStorageConfig();

            public String getType() {
                return this.type;
            }

            public MySQLConfig getMysql() {
                return this.mysql;
            }

            public FileStorageConfig getFile() {
                return this.file;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setMysql(MySQLConfig mysql) {
                this.mysql = mysql;
            }

            public void setFile(FileStorageConfig file) {
                this.file = file;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DatabaseConfig)) {
                    return false;
                }
                DatabaseConfig other = (DatabaseConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                MySQLConfig this$mysql = this.getMysql();
                MySQLConfig other$mysql = other.getMysql();
                if (this$mysql == null ? other$mysql != null : !((Object)this$mysql).equals(other$mysql)) {
                    return false;
                }
                FileStorageConfig this$file = this.getFile();
                FileStorageConfig other$file = other.getFile();
                return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DatabaseConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                MySQLConfig $mysql = this.getMysql();
                result = result * 59 + ($mysql == null ? 43 : ((Object)$mysql).hashCode());
                FileStorageConfig $file = this.getFile();
                result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
                return result;
            }

            public String toString() {
                return "ConfigManager.Config.DatabaseConfig(type=" + this.getType() + ", mysql=" + this.getMysql() + ", file=" + this.getFile() + ")";
            }

            public static class MySQLConfig {
                private String host = "localhost";
                private int port = 3306;
                private String database = "aevorinreports";
                private String username = "root";
                private String password = "";

                public String getHost() {
                    return this.host;
                }

                public int getPort() {
                    return this.port;
                }

                public String getDatabase() {
                    return this.database;
                }

                public String getUsername() {
                    return this.username;
                }

                public String getPassword() {
                    return this.password;
                }

                public void setHost(String host) {
                    this.host = host;
                }

                public void setPort(int port) {
                    this.port = port;
                }

                public void setDatabase(String database) {
                    this.database = database;
                }

                public void setUsername(String username) {
                    this.username = username;
                }

                public void setPassword(String password) {
                    this.password = password;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MySQLConfig)) {
                        return false;
                    }
                    MySQLConfig other = (MySQLConfig)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.getPort() != other.getPort()) {
                        return false;
                    }
                    String this$host = this.getHost();
                    String other$host = other.getHost();
                    if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                        return false;
                    }
                    String this$database = this.getDatabase();
                    String other$database = other.getDatabase();
                    if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
                        return false;
                    }
                    String this$username = this.getUsername();
                    String other$username = other.getUsername();
                    if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                        return false;
                    }
                    String this$password = this.getPassword();
                    String other$password = other.getPassword();
                    return !(this$password == null ? other$password != null : !this$password.equals(other$password));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof MySQLConfig;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.getPort();
                    String $host = this.getHost();
                    result = result * 59 + ($host == null ? 43 : $host.hashCode());
                    String $database = this.getDatabase();
                    result = result * 59 + ($database == null ? 43 : $database.hashCode());
                    String $username = this.getUsername();
                    result = result * 59 + ($username == null ? 43 : $username.hashCode());
                    String $password = this.getPassword();
                    result = result * 59 + ($password == null ? 43 : $password.hashCode());
                    return result;
                }

                public String toString() {
                    return "ConfigManager.Config.DatabaseConfig.MySQLConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
                }
            }

            public static class FileStorageConfig {
                private String path = "database/reports.db";

                public String getPath() {
                    return this.path;
                }

                public void setPath(String path) {
                    this.path = path;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FileStorageConfig)) {
                        return false;
                    }
                    FileStorageConfig other = (FileStorageConfig)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$path = this.getPath();
                    String other$path = other.getPath();
                    return !(this$path == null ? other$path != null : !this$path.equals(other$path));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof FileStorageConfig;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $path = this.getPath();
                    result = result * 59 + ($path == null ? 43 : $path.hashCode());
                    return result;
                }

                public String toString() {
                    return "ConfigManager.Config.DatabaseConfig.FileStorageConfig(path=" + this.getPath() + ")";
                }
            }
        }

        public static class ReportsConfig {
            private int cooldownSeconds = 300;
            private boolean allowAnonymousReports = true;
            private int maxActiveReportsPerPlayer = 3;
            private int chatHistoryLines = 50;
            private boolean logInventory = true;
            private boolean logLocation = true;

            public int getCooldownSeconds() {
                return this.cooldownSeconds;
            }

            public boolean isAllowAnonymousReports() {
                return this.allowAnonymousReports;
            }

            public int getMaxActiveReportsPerPlayer() {
                return this.maxActiveReportsPerPlayer;
            }

            public int getChatHistoryLines() {
                return this.chatHistoryLines;
            }

            public boolean isLogInventory() {
                return this.logInventory;
            }

            public boolean isLogLocation() {
                return this.logLocation;
            }

            public void setCooldownSeconds(int cooldownSeconds) {
                this.cooldownSeconds = cooldownSeconds;
            }

            public void setAllowAnonymousReports(boolean allowAnonymousReports) {
                this.allowAnonymousReports = allowAnonymousReports;
            }

            public void setMaxActiveReportsPerPlayer(int maxActiveReportsPerPlayer) {
                this.maxActiveReportsPerPlayer = maxActiveReportsPerPlayer;
            }

            public void setChatHistoryLines(int chatHistoryLines) {
                this.chatHistoryLines = chatHistoryLines;
            }

            public void setLogInventory(boolean logInventory) {
                this.logInventory = logInventory;
            }

            public void setLogLocation(boolean logLocation) {
                this.logLocation = logLocation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ReportsConfig)) {
                    return false;
                }
                ReportsConfig other = (ReportsConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getCooldownSeconds() != other.getCooldownSeconds()) {
                    return false;
                }
                if (this.isAllowAnonymousReports() != other.isAllowAnonymousReports()) {
                    return false;
                }
                if (this.getMaxActiveReportsPerPlayer() != other.getMaxActiveReportsPerPlayer()) {
                    return false;
                }
                if (this.getChatHistoryLines() != other.getChatHistoryLines()) {
                    return false;
                }
                if (this.isLogInventory() != other.isLogInventory()) {
                    return false;
                }
                return this.isLogLocation() == other.isLogLocation();
            }

            protected boolean canEqual(Object other) {
                return other instanceof ReportsConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getCooldownSeconds();
                result = result * 59 + (this.isAllowAnonymousReports() ? 79 : 97);
                result = result * 59 + this.getMaxActiveReportsPerPlayer();
                result = result * 59 + this.getChatHistoryLines();
                result = result * 59 + (this.isLogInventory() ? 79 : 97);
                result = result * 59 + (this.isLogLocation() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "ConfigManager.Config.ReportsConfig(cooldownSeconds=" + this.getCooldownSeconds() + ", allowAnonymousReports=" + this.isAllowAnonymousReports() + ", maxActiveReportsPerPlayer=" + this.getMaxActiveReportsPerPlayer() + ", chatHistoryLines=" + this.getChatHistoryLines() + ", logInventory=" + this.isLogInventory() + ", logLocation=" + this.isLogLocation() + ")";
            }
        }

        public static class SecurityConfig {
            private int maxFalseReports = 5;
            private int falseReportBanHours = 24;
            private int maxReportsBeforeFlag = 10;
            private String encryptionKey = "";
            private boolean enableTokenAuth = true;

            public int getMaxFalseReports() {
                return this.maxFalseReports;
            }

            public int getFalseReportBanHours() {
                return this.falseReportBanHours;
            }

            public int getMaxReportsBeforeFlag() {
                return this.maxReportsBeforeFlag;
            }

            public String getEncryptionKey() {
                return this.encryptionKey;
            }

            public boolean isEnableTokenAuth() {
                return this.enableTokenAuth;
            }

            public void setMaxFalseReports(int maxFalseReports) {
                this.maxFalseReports = maxFalseReports;
            }

            public void setFalseReportBanHours(int falseReportBanHours) {
                this.falseReportBanHours = falseReportBanHours;
            }

            public void setMaxReportsBeforeFlag(int maxReportsBeforeFlag) {
                this.maxReportsBeforeFlag = maxReportsBeforeFlag;
            }

            public void setEncryptionKey(String encryptionKey) {
                this.encryptionKey = encryptionKey;
            }

            public void setEnableTokenAuth(boolean enableTokenAuth) {
                this.enableTokenAuth = enableTokenAuth;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SecurityConfig)) {
                    return false;
                }
                SecurityConfig other = (SecurityConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getMaxFalseReports() != other.getMaxFalseReports()) {
                    return false;
                }
                if (this.getFalseReportBanHours() != other.getFalseReportBanHours()) {
                    return false;
                }
                if (this.getMaxReportsBeforeFlag() != other.getMaxReportsBeforeFlag()) {
                    return false;
                }
                if (this.isEnableTokenAuth() != other.isEnableTokenAuth()) {
                    return false;
                }
                String this$encryptionKey = this.getEncryptionKey();
                String other$encryptionKey = other.getEncryptionKey();
                return !(this$encryptionKey == null ? other$encryptionKey != null : !this$encryptionKey.equals(other$encryptionKey));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SecurityConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getMaxFalseReports();
                result = result * 59 + this.getFalseReportBanHours();
                result = result * 59 + this.getMaxReportsBeforeFlag();
                result = result * 59 + (this.isEnableTokenAuth() ? 79 : 97);
                String $encryptionKey = this.getEncryptionKey();
                result = result * 59 + ($encryptionKey == null ? 43 : $encryptionKey.hashCode());
                return result;
            }

            public String toString() {
                return "ConfigManager.Config.SecurityConfig(maxFalseReports=" + this.getMaxFalseReports() + ", falseReportBanHours=" + this.getFalseReportBanHours() + ", maxReportsBeforeFlag=" + this.getMaxReportsBeforeFlag() + ", encryptionKey=" + this.getEncryptionKey() + ", enableTokenAuth=" + this.isEnableTokenAuth() + ")";
            }
        }

        public static class NotificationsConfig {
            private boolean enableChatNotifications = true;
            private boolean enableTitleNotifications = true;
            private boolean enableSoundNotifications = true;
            private String notificationSound = "BLOCK_NOTE_BLOCK_PLING";

            public boolean isEnableChatNotifications() {
                return this.enableChatNotifications;
            }

            public boolean isEnableTitleNotifications() {
                return this.enableTitleNotifications;
            }

            public boolean isEnableSoundNotifications() {
                return this.enableSoundNotifications;
            }

            public String getNotificationSound() {
                return this.notificationSound;
            }

            public void setEnableChatNotifications(boolean enableChatNotifications) {
                this.enableChatNotifications = enableChatNotifications;
            }

            public void setEnableTitleNotifications(boolean enableTitleNotifications) {
                this.enableTitleNotifications = enableTitleNotifications;
            }

            public void setEnableSoundNotifications(boolean enableSoundNotifications) {
                this.enableSoundNotifications = enableSoundNotifications;
            }

            public void setNotificationSound(String notificationSound) {
                this.notificationSound = notificationSound;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NotificationsConfig)) {
                    return false;
                }
                NotificationsConfig other = (NotificationsConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isEnableChatNotifications() != other.isEnableChatNotifications()) {
                    return false;
                }
                if (this.isEnableTitleNotifications() != other.isEnableTitleNotifications()) {
                    return false;
                }
                if (this.isEnableSoundNotifications() != other.isEnableSoundNotifications()) {
                    return false;
                }
                String this$notificationSound = this.getNotificationSound();
                String other$notificationSound = other.getNotificationSound();
                return !(this$notificationSound == null ? other$notificationSound != null : !this$notificationSound.equals(other$notificationSound));
            }

            protected boolean canEqual(Object other) {
                return other instanceof NotificationsConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isEnableChatNotifications() ? 79 : 97);
                result = result * 59 + (this.isEnableTitleNotifications() ? 79 : 97);
                result = result * 59 + (this.isEnableSoundNotifications() ? 79 : 97);
                String $notificationSound = this.getNotificationSound();
                result = result * 59 + ($notificationSound == null ? 43 : $notificationSound.hashCode());
                return result;
            }

            public String toString() {
                return "ConfigManager.Config.NotificationsConfig(enableChatNotifications=" + this.isEnableChatNotifications() + ", enableTitleNotifications=" + this.isEnableTitleNotifications() + ", enableSoundNotifications=" + this.isEnableSoundNotifications() + ", notificationSound=" + this.getNotificationSound() + ")";
            }
        }

        public static class PerformanceConfig {
            private boolean enableCaching = true;
            private int cacheDuration = 15;
            private int maxCacheSize = 1000;
            private boolean asyncProcessing = true;
            private int batchSize = 50;
            private int backgroundTaskInterval = 300;
            private int cacheCleanupInterval = 30;

            public boolean isEnableCaching() {
                return this.enableCaching;
            }

            public int getCacheDuration() {
                return this.cacheDuration;
            }

            public int getMaxCacheSize() {
                return this.maxCacheSize;
            }

            public boolean isAsyncProcessing() {
                return this.asyncProcessing;
            }

            public int getBatchSize() {
                return this.batchSize;
            }

            public int getBackgroundTaskInterval() {
                return this.backgroundTaskInterval;
            }

            public int getCacheCleanupInterval() {
                return this.cacheCleanupInterval;
            }

            public void setEnableCaching(boolean enableCaching) {
                this.enableCaching = enableCaching;
            }

            public void setCacheDuration(int cacheDuration) {
                this.cacheDuration = cacheDuration;
            }

            public void setMaxCacheSize(int maxCacheSize) {
                this.maxCacheSize = maxCacheSize;
            }

            public void setAsyncProcessing(boolean asyncProcessing) {
                this.asyncProcessing = asyncProcessing;
            }

            public void setBatchSize(int batchSize) {
                this.batchSize = batchSize;
            }

            public void setBackgroundTaskInterval(int backgroundTaskInterval) {
                this.backgroundTaskInterval = backgroundTaskInterval;
            }

            public void setCacheCleanupInterval(int cacheCleanupInterval) {
                this.cacheCleanupInterval = cacheCleanupInterval;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PerformanceConfig)) {
                    return false;
                }
                PerformanceConfig other = (PerformanceConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isEnableCaching() != other.isEnableCaching()) {
                    return false;
                }
                if (this.getCacheDuration() != other.getCacheDuration()) {
                    return false;
                }
                if (this.getMaxCacheSize() != other.getMaxCacheSize()) {
                    return false;
                }
                if (this.isAsyncProcessing() != other.isAsyncProcessing()) {
                    return false;
                }
                if (this.getBatchSize() != other.getBatchSize()) {
                    return false;
                }
                if (this.getBackgroundTaskInterval() != other.getBackgroundTaskInterval()) {
                    return false;
                }
                return this.getCacheCleanupInterval() == other.getCacheCleanupInterval();
            }

            protected boolean canEqual(Object other) {
                return other instanceof PerformanceConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isEnableCaching() ? 79 : 97);
                result = result * 59 + this.getCacheDuration();
                result = result * 59 + this.getMaxCacheSize();
                result = result * 59 + (this.isAsyncProcessing() ? 79 : 97);
                result = result * 59 + this.getBatchSize();
                result = result * 59 + this.getBackgroundTaskInterval();
                result = result * 59 + this.getCacheCleanupInterval();
                return result;
            }

            public String toString() {
                return "ConfigManager.Config.PerformanceConfig(enableCaching=" + this.isEnableCaching() + ", cacheDuration=" + this.getCacheDuration() + ", maxCacheSize=" + this.getMaxCacheSize() + ", asyncProcessing=" + this.isAsyncProcessing() + ", batchSize=" + this.getBatchSize() + ", backgroundTaskInterval=" + this.getBackgroundTaskInterval() + ", cacheCleanupInterval=" + this.getCacheCleanupInterval() + ")";
            }
        }
    }
}

