/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.config;

import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;

public class VelocityConfigManager {
    private final Path configPath;
    private Toml config;

    public VelocityConfigManager(Path dataDirectory) {
        this.configPath = dataDirectory.resolve("velocity-config.toml");
    }

    public void loadConfig() throws IOException {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            this.copyDefaultConfig();
        }
        this.config = new Toml().read(this.configPath.toFile());
        this.handleTokenGeneration();
    }

    private void copyDefaultConfig() throws IOException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("velocity-config.toml");){
            if (is == null) {
                throw new IOException("Default config not found in resources");
            }
            Files.copy(is, this.configPath, new CopyOption[0]);
        }
    }

    private void handleTokenGeneration() throws IOException {
        Map authConfig = (Map)this.config.getTable("auth").to(Map.class);
        String token = (String)authConfig.get("token");
        boolean regenerateToken = authConfig.getOrDefault("regenerate-token", false);
        if (token == null || token.isEmpty() || regenerateToken) {
            token = this.generateSecureToken();
            String content = new String(Files.readAllBytes(this.configPath));
            String updatedContent = content.replaceFirst("token = \".*\"", "token = \"" + token + "\"");
            Files.write(this.configPath, updatedContent.getBytes(), new OpenOption[0]);
            this.config = new Toml().read(this.configPath.toFile());
        }
    }

    private String generateSecureToken() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] tokenBytes = new byte[32];
        secureRandom.nextBytes(tokenBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(tokenBytes);
    }

    public String getToken() {
        return this.config.getString("auth.token");
    }

    public Toml getConfig() {
        return this.config;
    }

    public boolean isCacheEnabled() {
        return this.config.getBoolean("performance.cache-enabled");
    }

    public int getMaxCachedReports() {
        return this.config.getLong("performance.max-cached-reports").intValue();
    }

    public int getCacheExpiration() {
        return this.config.getLong("performance.cache-expiration").intValue();
    }

    public boolean isAsyncProcessingEnabled() {
        return this.config.getBoolean("performance.async-processing");
    }

    public int getAsyncThreadPoolSize() {
        return this.config.getLong("performance.async-thread-pool-size").intValue();
    }

    public int getMaxAsyncQueueSize() {
        return this.config.getLong("performance.max-async-queue-size").intValue();
    }
}

