/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.gui;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReportReasonContainerGUI {
    private final BukkitPlugin plugin;

    public ReportReasonContainerGUI(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void showReasonContainerGUI(Player player, String targetPlayer) {
        List reasons = this.plugin.getConfig().getStringList("reports.categories");
        if (reasons.isEmpty()) {
            reasons = new ArrayList<String>(List.of("Hacking/Cheating", "Harassment/Bullying", "Inappropriate Language", "Spam/Advertisement", "Griefing/Vandalism", "Exploiting Bugs", "Inappropriate Skin/Name"));
        }
        reasons = reasons.stream().filter(reason -> !reason.equalsIgnoreCase("Other")).collect(Collectors.toList());
        int size = 54;
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)("Report: " + targetPlayer));
        ItemStack background = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (int i = 0; i < size; ++i) {
            gui.setItem(i, background);
        }
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta infoMeta = info.getItemMeta();
        if (infoMeta != null) {
            infoMeta.setDisplayName("\u00a7e\u00a7lReporting: \u00a7b" + targetPlayer);
            infoMeta.setLore(List.of("\u00a77", "\u00a7fSelect a reason to report this player", "\u00a7fClick on any icon to submit your report", "\u00a77"));
            info.setItemMeta(infoMeta);
        }
        gui.setItem(13, info);
        int[] slots = reasons.size() <= 7 ? new int[]{28, 29, 30, 31, 32, 33, 34} : new int[]{27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42};
        for (int i = 0; i < Math.min(reasons.size(), slots.length); ++i) {
            String reason2 = (String)reasons.get(i);
            ItemStack item = this.getReasonItem(reason2);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("\u00a7b\u00a7l" + reason2);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                meta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7eTarget: \u00a7f" + targetPlayer, "\u00a7eReason: \u00a7f" + reason2, "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7aClick to submit report"));
                item.setItemMeta(meta);
                item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
            }
            gui.setItem(slots[i], item);
        }
        player.openInventory(gui);
    }

    private ItemStack getReasonItem(String reason) {
        return switch (reason.toLowerCase()) {
            case "hacking/cheating" -> new ItemStack(Material.COMPASS);
            case "harassment/bullying" -> new ItemStack(Material.PAPER);
            case "inappropriate language" -> new ItemStack(Material.BOOK);
            case "spam/advertisement" -> new ItemStack(Material.MAP);
            case "griefing/vandalism" -> new ItemStack(Material.TNT);
            case "exploiting bugs" -> new ItemStack(Material.SPIDER_EYE);
            case "inappropriate skin/name" -> new ItemStack(Material.NAME_TAG);
            default -> new ItemStack(Material.WRITABLE_BOOK);
        };
    }
}

