/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.bukkit;

import dev.aevorinstudios.aevorinReports.bukkit.CustomReasonHandler;
import dev.aevorinstudios.aevorinReports.bukkit.commands.BukkitReportCommand;
import dev.aevorinstudios.aevorinReports.bukkit.commands.BukkitReportsCommand;
import dev.aevorinstudios.aevorinReports.bukkit.commands.ReportReasonContainerListener;
import dev.aevorinstudios.aevorinReports.bukkit.commands.ReportsContainerListener;
import dev.aevorinstudios.aevorinReports.bukkit.commands.ShiftReportCommand;
import dev.aevorinstudios.aevorinReports.bukkit.commands.ViewReportCommand;
import dev.aevorinstudios.aevorinReports.commands.HiddenCommandManager;
import dev.aevorinstudios.aevorinReports.config.ConfigManager;
import dev.aevorinstudios.aevorinReports.database.DatabaseManager;
import dev.aevorinstudios.aevorinReports.listeners.CommandHidingListener;
import dev.aevorinstudios.aevorinReports.sync.TokenSyncManager;
import dev.aevorinstudios.aevorinReports.utils.ExceptionHandler;
import dev.aevorinstudios.aevorinReports.utils.ModrinthUpdateChecker;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlugin
extends JavaPlugin
implements CommandExecutor {
    private static BukkitPlugin instance;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private TokenSyncManager tokenSyncManager;
    private ModrinthUpdateChecker updateChecker;
    private CustomReasonHandler customReasonHandler;
    private BukkitReportCommand bukkitReportCommand;
    private boolean databaseInitialized = false;
    private boolean configInitialized = false;

    public void onEnable() {
        try {
            instance = this;
            this.getLogger().info("Initializing AevorinReports");
            this.initializeExceptionHandler();
            if (!this.initializeConfig()) {
                this.getLogger().severe("Configuration initialization failed. Using default values where possible.");
            }
            if (!this.initializeDatabase()) {
                this.getLogger().severe("Database initialization failed. Plugin functionality will be limited.");
            }
            this.customReasonHandler = new CustomReasonHandler(this);
            this.registerCommands();
            this.registerListeners();
            this.getCommand("ar").setExecutor((CommandExecutor)this);
            this.getCommand("aevorinreports").setExecutor((CommandExecutor)this);
            this.getServer().getPluginManager().registerEvents((Listener)new ReportsContainerListener(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new ReportReasonContainerListener(this), (Plugin)this);
            try {
                this.getCommand("viewreport").setExecutor((CommandExecutor)new ViewReportCommand(this));
            }
            catch (Exception e) {
                ExceptionHandler.getInstance().handleException(e, "Command Registration", Map.of("command", "viewreport", "class", "ViewReportCommand"));
            }
            try {
                this.getCommand("shiftreport").setExecutor((CommandExecutor)new ShiftReportCommand(this));
            }
            catch (Exception e) {
                ExceptionHandler.getInstance().handleException(e, "Command Registration", Map.of("command", "shiftreport", "class", "ShiftReportCommand"));
            }
            this.initializeTokenSync();
            new HiddenCommandManager(this).registerHiddenCommands();
            this.getServer().getPluginManager().registerEvents((Listener)new CommandHidingListener(), (Plugin)this);
            String modrinthProjectId = this.getConfig().getString("update-checker.modrinth-project-id", "your-project-id");
            if (!modrinthProjectId.equals("your-project-id")) {
                this.updateChecker = new ModrinthUpdateChecker(this, modrinthProjectId);
                this.updateChecker.startUpdateChecker();
                this.getLogger().info("Modrinth update checker initialized with project ID: " + modrinthProjectId);
            } else {
                this.getLogger().warning("Modrinth project ID not configured. Update checking is disabled.");
            }
            this.getLogger().info("AevorinReports has been enabled!");
        }
        catch (Exception e) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("plugin_version", this.getDescription().getVersion());
            context.put("server_version", Bukkit.getVersion());
            context.put("config_initialized", this.configInitialized);
            context.put("database_initialized", this.databaseInitialized);
            ExceptionHandler.getInstance().handleException(e, "Plugin Startup", context);
            this.getLogger().severe("Failed to enable AevorinReports due to a critical error. Check the logs for details.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if ((command.getName().equalsIgnoreCase("ar") || command.getName().equalsIgnoreCase("aevorinreports")) && args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("aevorinreports.reload")) {
                sender.sendMessage("\u00a7cYou don't have permission to reload the config!");
                return true;
            }
            try {
                this.reloadConfig();
                sender.sendMessage("\u00a7aAevorinReports configuration reloaded successfully!");
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cFailed to reload configuration. Check the console for errors.");
                this.getLogger().warning("Error reloading configuration: " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    public void onDisable() {
        this.getLogger().info("Shutting down AevorinReports");
        if (this.databaseManager != null) {
            try {
                this.getLogger().info("Closing database connections...");
                this.databaseManager.close();
                this.getLogger().info("Database connections closed successfully.");
            }
            catch (Exception e) {
                ExceptionHandler.getInstance().handleException(e, "Database Shutdown");
                this.getLogger().warning("Error while closing database connections.");
            }
        }
        if (this.tokenSyncManager != null) {
            try {
                this.getLogger().info("Cleaning up token synchronization...");
                this.tokenSyncManager.cleanup();
                this.getLogger().info("Token synchronization cleaned up successfully.");
            }
            catch (Exception e) {
                ExceptionHandler.getInstance().handleException(e, "TokenSync Shutdown");
                this.getLogger().warning("Error while cleaning up token synchronization.");
            }
        }
        this.getLogger().info("AevorinReports has been disabled!");
    }

    private boolean initializeConfig() {
        try {
            this.getLogger().info("\ud83d\udcdc Loading configuration files...");
            this.saveDefaultConfig();
            Path dataFolder = this.getDataFolder().toPath();
            this.configManager = ConfigManager.initialize(dataFolder);
            boolean valid = this.validateConfiguration();
            this.configInitialized = true;
            this.getLogger().info("Configuration loaded successfully" + (valid ? "." : " with warnings."));
            return valid;
        }
        catch (Exception e) {
            ExceptionHandler.getInstance().handleException(e, "Config Initialization");
            this.getLogger().severe("Failed to initialize configuration. Using default values where possible.");
            return false;
        }
    }

    private boolean validateConfiguration() {
        String token;
        boolean valid = true;
        String dbType = this.getConfig().getString("database.type", "");
        if (dbType.isEmpty()) {
            this.getLogger().warning("Database type not specified in config. Defaulting to SQLite.");
            valid = false;
        } else if ("mysql".equalsIgnoreCase(dbType)) {
            if (this.getConfig().getString("database.mysql.host", "").isEmpty()) {
                this.getLogger().warning("MySQL host not specified in config.");
                valid = false;
            }
            if (this.getConfig().getString("database.mysql.database", "").isEmpty()) {
                this.getLogger().warning("MySQL database name not specified in config.");
                valid = false;
            }
        }
        if (this.getConfig().getBoolean("proxy.enabled", false) && ((token = this.getConfig().getString("auth.token", "")).isEmpty() || token.equals("your_token_here"))) {
            this.getLogger().warning("Invalid proxy authentication token. Proxy synchronization will not work.");
            valid = false;
        }
        return valid;
    }

    private boolean initializeDatabase() {
        this.getLogger().info("\ud83d\uddc4\ufe0f Initializing database connection...");
        int maxRetries = 3;
        int retryCount = 0;
        while (retryCount < maxRetries) {
            try {
                ConfigManager.Config.DatabaseConfig dbConfig = this.configManager.getConfig().getDatabase();
                if ("mysql".equalsIgnoreCase(dbConfig.getType())) {
                    this.getLogger().info("Using MySQL database connection");
                    ConfigManager.Config.DatabaseConfig.MySQLConfig mysqlConfig = dbConfig.getMysql();
                    this.getLogger().info(String.format("Connecting to MySQL database: %s@%s:%d/%s", mysqlConfig.getUsername(), mysqlConfig.getHost(), mysqlConfig.getPort(), mysqlConfig.getDatabase()));
                    this.databaseManager = new DatabaseManager(mysqlConfig.getHost(), mysqlConfig.getPort(), mysqlConfig.getDatabase(), mysqlConfig.getUsername(), mysqlConfig.getPassword());
                } else {
                    this.getLogger().info("Using SQLite database connection");
                    ConfigManager.Config.DatabaseConfig.FileStorageConfig fileConfig = dbConfig.getFile();
                    this.getLogger().info("SQLite database path: " + fileConfig.getPath());
                    this.databaseManager = new DatabaseManager(fileConfig.getPath());
                }
                if (this.databaseManager.testConnection()) {
                    this.databaseInitialized = true;
                    this.getLogger().info("Database connection established successfully!");
                    return true;
                }
                throw new Exception("Database connection test failed");
            }
            catch (Exception e) {
                if (++retryCount >= maxRetries) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("retry_count", retryCount);
                    context.put("max_retries", maxRetries);
                    ExceptionHandler.getInstance().handleException(e, "Database Initialization", context);
                    this.getLogger().severe("Failed to initialize database after " + maxRetries + " attempts.");
                    return false;
                }
                this.getLogger().warning("Database connection attempt failed. Retrying... (" + retryCount + "/" + maxRetries + ")");
                try {
                    Thread.sleep(2000 * retryCount);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return false;
    }

    private void registerCommands() {
        this.getLogger().info("Registering commands...");
        try {
            this.bukkitReportCommand = new BukkitReportCommand(this);
            this.getCommand("report").setExecutor((CommandExecutor)this.bukkitReportCommand);
            this.getCommand("report").setTabCompleter((TabCompleter)this.bukkitReportCommand);
            this.getLogger().info("Registered 'report' command and tab completer");
        }
        catch (Exception e) {
            ExceptionHandler.getInstance().handleException(e, "Command Registration", Map.of("command", "report", "class", "BukkitReportCommand"));
        }
        try {
            this.getCommand("reports").setExecutor((CommandExecutor)new BukkitReportsCommand(this));
            this.getLogger().info("Registered 'reports' command");
        }
        catch (Exception e) {
            ExceptionHandler.getInstance().handleException(e, "Command Registration", Map.of("command", "reports", "class", "BukkitReportsCommand"));
        }
        this.getLogger().info("Commands registered successfully!");
    }

    private void registerListeners() {
        this.getLogger().info("Registering event listeners...");
        this.getLogger().info("Event listeners registered successfully!");
    }

    private void initializeTokenSync() {
        this.getLogger().info("Initializing token synchronization...");
        if (!this.getConfig().getBoolean("proxy.enabled", false)) {
            this.getLogger().info("Proxy synchronization is disabled in config. Skipping token sync initialization.");
            return;
        }
        try {
            this.tokenSyncManager = new TokenSyncManager(this);
            CompletionStage authFuture = this.tokenSyncManager.authenticate().orTimeout(30L, TimeUnit.SECONDS).exceptionally(ex -> {
                ExceptionHandler.getInstance().handleException((Throwable)ex, "TokenSync Authentication");
                this.getLogger().severe("Token authentication timed out or failed with exception.");
                return false;
            });
            ((CompletableFuture)authFuture).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.getLogger().info("Successfully authenticated with proxy server!");
                } else {
                    this.getLogger().warning("Failed to authenticate with proxy. Reports will not be synced.");
                    this.getLogger().warning("Please check your token configuration in config.yml");
                    Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                        if (this.isEnabled()) {
                            this.getLogger().info("Retrying proxy authentication...");
                            this.tokenSyncManager.authenticate().thenAccept(retrySuccess -> {
                                if (retrySuccess.booleanValue()) {
                                    this.getLogger().info("Successfully authenticated with proxy on retry!");
                                } else {
                                    this.getLogger().warning("Retry authentication failed. Reports will not be synced.");
                                }
                            });
                        }
                    }, 6000L);
                }
            });
            this.getLogger().info("Token synchronization initialized successfully!");
        }
        catch (Exception e) {
            ExceptionHandler.getInstance().handleException(e, "TokenSync Initialization");
            this.getLogger().severe("Failed to initialize token synchronization.");
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        if (!this.databaseInitialized) {
            this.getLogger().warning("Attempting to access database manager before initialization");
        }
        return this.databaseManager;
    }

    public TokenSyncManager getTokenSyncManager() {
        return this.tokenSyncManager;
    }

    private void initializeExceptionHandler() {
        this.getLogger().info("Initializing enhanced exception handler...");
        ExceptionHandler handler = ExceptionHandler.getInstance();
        int maxRepetitions = this.getConfig().getInt("error_handler.max_repetitions", 5);
        long suppressionMinutes = this.getConfig().getLong("error_handler.suppression_minutes", 15L);
        boolean detailedLogging = this.getConfig().getBoolean("error_handler.detailed_logging", true);
        boolean logStackTraces = this.getConfig().getBoolean("error_handler.log_stack_traces", true);
        boolean groupSimilarErrors = this.getConfig().getBoolean("error_handler.group_similar_errors", true);
        handler.configure(maxRepetitions, suppressionMinutes, detailedLogging, logStackTraces);
        handler.setGroupSimilarErrors(groupSimilarErrors);
        handler.installGlobalHandler();
        this.getLogger().setFilter(record -> {
            if (record.getThrown() != null) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("log_level", record.getLevel().getName());
                context.put("logger_name", record.getLoggerName());
                context.put("message", record.getMessage());
                context.put("thread", Thread.currentThread().getName());
                context.put("plugin_version", this.getDescription().getVersion());
                if (Bukkit.getServer() != null) {
                    context.put("server_version", Bukkit.getVersion());
                    context.put("bukkit_version", Bukkit.getBukkitVersion());
                    context.put("online_mode", Bukkit.getOnlineMode());
                }
                handler.handleException(record.getThrown(), "Logger", context);
                if (record.getLevel() != Level.SEVERE) {
                    record.setThrown(null);
                }
            }
            return true;
        });
        this.getLogger().info("Enhanced exception handler initialized successfully!");
    }

    public static BukkitPlugin getInstance() {
        return instance;
    }

    public CustomReasonHandler getCustomReasonHandler() {
        return this.customReasonHandler;
    }

    public BukkitReportCommand getBukkitReportCommand() {
        return this.bukkitReportCommand;
    }
}

