/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.bukkit;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class CustomReasonHandler
implements Listener {
    private final BukkitPlugin plugin;
    private final Map<UUID, CustomReasonData> pendingCustomReasons;

    public CustomReasonHandler(BukkitPlugin plugin) {
        this.plugin = plugin;
        this.pendingCustomReasons = new HashMap<UUID, CustomReasonData>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void startCustomReason(Player player, String targetPlayer) {
        this.pendingCustomReasons.put(player.getUniqueId(), new CustomReasonData(targetPlayer));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        CustomReasonData data = this.pendingCustomReasons.get(player.getUniqueId());
        if (data != null) {
            event.setCancelled(true);
            String reason = event.getMessage();
            int minLength = this.plugin.getConfig().getInt("reports.custom-reason-min-length", 10);
            int maxLength = this.plugin.getConfig().getInt("reports.custom-reason-max-length", 100);
            if (reason.length() < minLength) {
                player.sendMessage(ChatColor.RED + this.plugin.getConfig().getString("messages.custom-reason-too-short", "Your reason is too short. Minimum length is " + minLength + " characters."));
                return;
            }
            if (reason.length() > maxLength) {
                player.sendMessage(ChatColor.RED + this.plugin.getConfig().getString("messages.custom-reason-too-long", "Your reason is too long. Maximum length is " + maxLength + " characters."));
                return;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                this.plugin.getBukkitReportCommand().createReport(player, data.targetPlayer(), reason);
                this.pendingCustomReasons.remove(player.getUniqueId());
            });
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.pendingCustomReasons.remove(event.getPlayer().getUniqueId());
    }

    private record CustomReasonData(String targetPlayer) {
    }
}

