/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.bukkit.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.config.ConfigManager;
import dev.aevorinstudios.aevorinReports.database.DatabaseManager;
import dev.aevorinstudios.aevorinReports.reports.Report;
import dev.aevorinstudios.aevorinReports.utils.PlayerNameResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitReportsCommand
implements CommandExecutor,
TabCompleter {
    private final BukkitPlugin plugin;
    private final Map<UUID, Long> lastCommandTime = new HashMap<UUID, Long>();
    private final Map<Report.ReportStatus, List<Report>> reportCache = new HashMap<Report.ReportStatus, List<Report>>();
    private static final long COMMAND_COOLDOWN = 500L;
    private static final long CACHE_DURATION = 5000L;
    private long lastCacheUpdate = 0L;

    public BukkitReportsCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player) || !sender.hasPermission("aevorinreports.manage")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            ArrayList<String> groups = new ArrayList<String>();
            String partialGroup = args[0].toUpperCase();
            for (Report.ReportStatus status : Report.ReportStatus.values()) {
                if (!status.name().startsWith(partialGroup)) continue;
                groups.add(status.name());
            }
            return groups;
        }
        return new ArrayList<String>();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Report.ReportStatus status;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ConfigManager.getInstance().getMessage("messages.errors.player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.manage")) {
            sender.sendMessage(ConfigManager.getInstance().getMessage("messages.errors.no-permission"));
            return true;
        }
        if (args.length == 0) {
            this.showReportsBook(player);
            return true;
        }
        String group = args[0].toUpperCase();
        try {
            status = Report.ReportStatus.valueOf(group);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(ConfigManager.getInstance().getMessage("messages.errors.invalid-group"));
            return true;
        }
        this.showReportsBookByStatus(player, status);
        return true;
    }

    private void showReportsBook(Player player) {
        ItemStack book;
        BookMeta meta;
        long lastTime;
        String guiType = this.plugin.getConfig().getString("reports.gui.type", "book");
        if (guiType.equalsIgnoreCase("container")) {
            this.showReportsContainerGUI(player);
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastCommandTime.getOrDefault(player.getUniqueId(), 0L).longValue()) < 500L) {
            return;
        }
        this.lastCommandTime.put(player.getUniqueId(), currentTime);
        if (currentTime - this.lastCacheUpdate > 5000L) {
            this.reportCache.clear();
            this.lastCacheUpdate = currentTime;
        }
        if ((meta = (BookMeta)(book = new ItemStack(Material.WRITTEN_BOOK)).getItemMeta()) == null) {
            String errorMsg = ConfigManager.getInstance().getMessage("messages.errors.book-meta-null");
            player.sendMessage(errorMsg != null ? errorMsg : "Error creating book.");
            return;
        }
        String title = ConfigManager.getInstance().getMessage("messages.book.main-title");
        meta.setTitle(title != null ? title : "Report Management");
        meta.setAuthor("Server Admin");
        ArrayList<Component> pages = new ArrayList<Component>();
        Component mainPage = ((TextComponent)((TextComponent)Component.empty().append(Component.text("Report Categories", (TextColor)NamedTextColor.DARK_RED))).append(Component.newline())).append(Component.newline());
        for (Report.ReportStatus status : Report.ReportStatus.values()) {
            List reports = this.reportCache.computeIfAbsent(status, k -> DatabaseManager.getInstance().getReportsByStatus(status));
            String groupName = status.name();
            int count = reports.size();
            String bulletSymbol = ConfigManager.getInstance().getSymbol("group_bullet");
            bulletSymbol = bulletSymbol != null ? bulletSymbol : "\u2022 ";
            Object hoverText = ConfigManager.getInstance().getFormattedMessage("messages.book.view-group", "{count}", String.valueOf(count), "{status}", groupName.toLowerCase());
            if (hoverText == null || ((String)hoverText).isEmpty()) {
                hoverText = "View " + count + " " + groupName.toLowerCase() + " reports";
            }
            StyleSetter groupComponent = ((TextComponent)((TextComponent)Component.text(bulletSymbol + groupName + " ", (TextColor)NamedTextColor.GOLD).append(Component.text("(" + count + ")", (TextColor)NamedTextColor.GREEN))).clickEvent(ClickEvent.runCommand("/reports " + groupName))).hoverEvent(HoverEvent.showText(Component.text((String)hoverText)));
            mainPage = mainPage.append((Component)groupComponent).append(Component.newline()).append(Component.newline());
        }
        pages.add(mainPage);
        meta.pages(pages);
        book.setItemMeta((ItemMeta)meta);
        player.openBook(book);
    }

    private void showReportsContainerGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)"Reports Menu");
        ItemStack pending = new ItemStack(Material.PAPER);
        ItemMeta pendingMeta = pending.getItemMeta();
        pendingMeta.setDisplayName("\u00a7ePending Reports");
        pendingMeta.setLore(List.of("\u00a77View all pending reports.", "\u00a7eClick to view!"));
        pending.setItemMeta(pendingMeta);
        gui.setItem(10, pending);
        ItemStack resolved = new ItemStack(Material.BOOK);
        ItemMeta resolvedMeta = resolved.getItemMeta();
        resolvedMeta.setDisplayName("\u00a7aResolved Reports");
        resolvedMeta.setLore(List.of("\u00a77View all resolved reports.", "\u00a7eClick to view!"));
        resolved.setItemMeta(resolvedMeta);
        gui.setItem(13, resolved);
        ItemStack rejected = new ItemStack(Material.BARRIER);
        ItemMeta rejectedMeta = rejected.getItemMeta();
        rejectedMeta.setDisplayName("\u00a7cRejected Reports");
        rejectedMeta.setLore(List.of("\u00a77View all rejected reports.", "\u00a7eClick to view!"));
        rejected.setItemMeta(rejectedMeta);
        gui.setItem(16, rejected);
        player.openInventory(gui);
    }

    private void showReportsBookByStatus(Player player, Report.ReportStatus status) {
        ItemStack book;
        BookMeta meta;
        long lastTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastCommandTime.getOrDefault(player.getUniqueId(), 0L).longValue()) < 500L) {
            return;
        }
        this.lastCommandTime.put(player.getUniqueId(), currentTime);
        if (currentTime - this.lastCacheUpdate > 5000L) {
            this.reportCache.clear();
            this.lastCacheUpdate = currentTime;
        }
        if ((meta = (BookMeta)(book = new ItemStack(Material.WRITTEN_BOOK)).getItemMeta()) == null) {
            String errorMsg = ConfigManager.getInstance().getMessage("messages.errors.book-meta-null");
            player.sendMessage(errorMsg != null ? errorMsg : "Error creating book.");
            return;
        }
        String groupName = status.name();
        String title = ConfigManager.getInstance().getFormattedMessage("messages.book.group-title", "{status}", status.name(), "{group}", groupName.toLowerCase());
        meta.setTitle((String)(title != null ? title : status.name() + " Reports"));
        meta.setAuthor("Server Admin");
        ArrayList<Component> pages = new ArrayList<Component>();
        List reports = this.reportCache.computeIfAbsent(status, k -> DatabaseManager.getInstance().getReportsByStatus(status));
        if (reports == null) {
            String errorMsg = ConfigManager.getInstance().getMessage("messages.errors.no-reports");
            player.sendMessage(errorMsg != null ? errorMsg : "No reports found.");
            return;
        }
        if (reports.isEmpty()) {
            Object noReportsMessage = ConfigManager.getInstance().getFormattedMessage("messages.errors.no-reports", "{status}", status.name().toLowerCase(), "", "");
            if (noReportsMessage == null || ((String)noReportsMessage).isEmpty()) {
                noReportsMessage = "No " + status.name().toLowerCase() + " reports found.";
            }
            Component emptyPage = ((TextComponent)((TextComponent)Component.text((String)noReportsMessage, (TextColor)NamedTextColor.RED).append(Component.newline())).append(Component.newline())).append((Component)((TextComponent)((TextComponent)Component.text("[Back to Categories]", (TextColor)NamedTextColor.BLUE).decorate(TextDecoration.BOLD)).clickEvent(ClickEvent.runCommand("/reports"))).hoverEvent(HoverEvent.showText(Component.text("Return to report categories", (TextColor)NamedTextColor.BLUE).decorate(TextDecoration.BOLD))));
            pages.add(emptyPage);
        } else {
            int reportsPerPage = ConfigManager.getInstance().getReportsPerPage();
            if (reportsPerPage <= 0) {
                reportsPerPage = 5;
            }
            Component currentPage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text(status.name() + " Reports", (TextColor)NamedTextColor.DARK_RED))).append(Component.newline())).append(Component.text("Total: " + reports.size(), (TextColor)NamedTextColor.GRAY))).append(Component.newline())).append(Component.newline());
            int count = 0;
            int reportNumber = 1;
            for (Report report : reports) {
                String reportedName;
                if (count > 0 && count % reportsPerPage == 0) {
                    currentPage = currentPage.append(Component.newline()).append((Component)((TextComponent)Component.text("[Back to Categories]", (TextColor)NamedTextColor.BLUE).clickEvent(ClickEvent.runCommand("/reports"))).hoverEvent(HoverEvent.showText(Component.text("Return to report categories"))));
                    pages.add(currentPage);
                    currentPage = Component.empty();
                }
                reportedName = (reportedName = PlayerNameResolver.resolvePlayerName(report.getReported())) != null ? reportedName : "Unknown Player";
                String numberPrefix = "#";
                String afterNumberSpacing = ": ";
                String numberPrefixObj = ConfigManager.getInstance().getText("messages.report-format.number-prefix");
                String afterNumberSpacingObj = ConfigManager.getInstance().getText("gui.spacing.after_number");
                if (numberPrefixObj != null && !numberPrefixObj.toString().isEmpty()) {
                    numberPrefix = numberPrefixObj.toString();
                }
                if (afterNumberSpacingObj != null && !afterNumberSpacingObj.toString().isEmpty()) {
                    afterNumberSpacing = afterNumberSpacingObj.toString();
                }
                TextComponent numberComponent = Component.text(numberPrefix + reportNumber + afterNumberSpacing, (TextColor)NamedTextColor.GOLD);
                Object hoverText = "Click to view details for report #" + report.getId();
                String hoverTextObj = ConfigManager.getInstance().getMessage("messages.book.view-details");
                if (hoverTextObj != null && !hoverTextObj.toString().isEmpty()) {
                    hoverText = hoverTextObj.toString();
                }
                StyleSetter nameComponent = ((TextComponent)Component.text(reportedName, (TextColor)NamedTextColor.RED).clickEvent(ClickEvent.runCommand("/viewreport " + report.getId()))).hoverEvent(HoverEvent.showText(Component.text((String)hoverText)));
                currentPage = currentPage.append(numberComponent).append((Component)nameComponent).append(Component.newline()).append(Component.newline());
                ++count;
                ++reportNumber;
            }
            if (count > 0) {
                currentPage = currentPage.append(Component.newline()).append((Component)((TextComponent)Component.text("[Back to Categories]", (TextColor)NamedTextColor.BLUE).clickEvent(ClickEvent.runCommand("/reports"))).hoverEvent(HoverEvent.showText(Component.text("Return to report categories"))));
                pages.add(currentPage);
            }
        }
        meta.pages(pages);
        book.setItemMeta((ItemMeta)meta);
        player.openBook(book);
    }
}

