/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.bukkit.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CategoryContainerGUI {
    private final BukkitPlugin plugin;

    public CategoryContainerGUI(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void openCategoryGUI(Player player, Report.ReportStatus status, List<Report> reports, int page) {
        int i;
        int size = 54;
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)(status.name().charAt(0) + status.name().substring(1).toLowerCase() + " Reports"));
        ItemStack background = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (i = 0; i < 9; ++i) {
            gui.setItem(i, background);
        }
        for (i = 45; i < 54; ++i) {
            gui.setItem(i, background);
        }
        for (i = 9; i <= 36; i += 9) {
            gui.setItem(i, background);
        }
        for (i = 17; i <= 44; i += 9) {
            gui.setItem(i, background);
        }
        ArrayList<Integer> innerSlots = new ArrayList<Integer>();
        for (int row = 1; row < 5; ++row) {
            for (int col = 1; col < 8; ++col) {
                innerSlots.add(row * 9 + col);
            }
        }
        innerSlots.remove((Object)49);
        int reportsPerPage = innerSlots.size();
        int totalPages = (int)Math.ceil((double)reports.size() / (double)reportsPerPage);
        if (totalPages == 0) {
            totalPages = 1;
        }
        int startIndex = page * reportsPerPage;
        int endIndex = Math.min(startIndex + reportsPerPage, reports.size());
        if (totalPages > 1) {
            ItemStack pageIndicator = new ItemStack(Material.PAPER);
            ItemMeta pageMeta = pageIndicator.getItemMeta();
            pageMeta.setDisplayName("\u00a7f\u00a7lPage " + (page + 1) + " of " + totalPages);
            pageMeta.setLore(List.of("\u00a77Showing " + (startIndex + 1) + "-" + endIndex + " of " + reports.size() + " reports"));
            pageIndicator.setItemMeta(pageMeta);
            gui.setItem(49, pageIndicator);
            if (page > 0) {
                ItemStack prevArrow = new ItemStack(Material.ARROW);
                ItemMeta prevMeta = prevArrow.getItemMeta();
                prevMeta.setDisplayName("\u00a7e\u00a7lPrevious Page");
                prevMeta.setLore(List.of("\u00a77Go to page " + page));
                prevArrow.setItemMeta(prevMeta);
                gui.setItem(48, prevArrow);
            }
            if (page < totalPages - 1) {
                ItemStack nextArrow = new ItemStack(Material.ARROW);
                ItemMeta nextMeta = nextArrow.getItemMeta();
                nextMeta.setDisplayName("\u00a7e\u00a7lNext Page");
                nextMeta.setLore(List.of("\u00a77Go to page " + (page + 2)));
                nextArrow.setItemMeta(nextMeta);
                gui.setItem(50, nextArrow);
            }
        }
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            Report report = reports.get(i2);
            int slotIndex = i2 - startIndex;
            if (slotIndex >= innerSlots.size()) break;
            String reporterName = Bukkit.getOfflinePlayer((UUID)report.getReporter()).getName();
            String reportedName = Bukkit.getOfflinePlayer((UUID)report.getReported()).getName();
            if (reporterName == null) {
                reporterName = "Unknown";
            }
            if (reportedName == null) {
                reportedName = "Unknown";
            }
            ItemStack item = new ItemStack(Material.WRITABLE_BOOK);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName("\u00a7b" + reporterName + " \u2192 " + reportedName);
            meta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Reason: " + report.getReason(), "\u00a77ID: " + report.getId(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7eClick to manage (read-only)"));
            item.setItemMeta(meta);
            gui.setItem(((Integer)innerSlots.get(slotIndex)).intValue(), item);
        }
        player.openInventory(gui);
    }

    public void openCategoryGUI(Player player, Report.ReportStatus status, List<Report> reports) {
        this.openCategoryGUI(player, status, reports, 0);
    }
}

