/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.bukkit.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.bukkit.commands.BukkitReportCommand;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReportReasonContainerListener
implements Listener {
    private final BukkitPlugin plugin;

    public ReportReasonContainerListener(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (!title.startsWith("Report: ")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null || lore.size() < 4) {
            return;
        }
        String targetLine = (String)lore.get(1);
        String reasonLine = (String)lore.get(2);
        if (!targetLine.startsWith("\u00a7eTarget: ") || !reasonLine.startsWith("\u00a7eReason: ")) {
            return;
        }
        String targetPlayer = targetLine.substring("\u00a7eTarget: \u00a7f".length());
        String reason = reasonLine.substring("\u00a7eReason: \u00a7f".length());
        player.closeInventory();
        player.sendMessage("\u00a7aSubmitting report against " + targetPlayer + " for " + reason);
        new BukkitReportCommand(this.plugin).createReport(player, targetPlayer, reason);
    }
}

