/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.bukkit.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.bukkit.commands.ReportManageGUI;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShiftReportCommand
implements CommandExecutor {
    private final BukkitPlugin plugin;

    public ShiftReportCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.manage")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
            return true;
        }
        if (args.length != 2) {
            player.sendMessage(ChatColor.RED + "Usage: /shiftreport <id> <status>");
            return true;
        }
        try {
            long reportId = Long.parseLong(args[0]);
            String statusStr = args[1].toUpperCase();
            Report.ReportStatus newStatus = Report.ReportStatus.valueOf(statusStr);
            Report report = this.plugin.getDatabaseManager().getReport(reportId);
            if (report == null) {
                player.sendMessage(ChatColor.RED + "Report not found!");
                return true;
            }
            if (report.getStatus() == newStatus) {
                player.sendMessage(ChatColor.YELLOW + "Report is already in that category!");
                return true;
            }
            report.setStatus(newStatus);
            this.plugin.getDatabaseManager().updateReport(report);
            player.sendMessage(ChatColor.DARK_GRAY + "[Report System] " + ChatColor.GRAY + "ID: " + reportId + " \u2192 " + newStatus.name());
            this.plugin.getLogger().fine("Report " + reportId + " status changed to " + newStatus.name() + " by " + player.getName());
            new ReportManageGUI(this.plugin).open(player, report);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ChatColor.RED + "Invalid report ID!");
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(ChatColor.RED + "Invalid status! Valid: " + Arrays.toString((Object[])Report.ReportStatus.values()));
        }
        return true;
    }
}

