/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.bukkit.commands;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.reports.Report;
import dev.aevorinstudios.aevorinReports.utils.PlayerNameResolver;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewReportCommand
implements CommandExecutor {
    private final BukkitPlugin plugin;

    public ViewReportCommand(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("aevorinreports.manage")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(ChatColor.RED + "Usage: /viewreport <id>");
            return true;
        }
        try {
            long reportId = Long.parseLong(args[0]);
            this.showReportDetails(player, reportId);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ChatColor.RED + "Invalid report ID!");
        }
        return true;
    }

    private void showReportDetails(Player player, long reportId) {
        Report report = this.plugin.getDatabaseManager().getReport(reportId);
        if (report == null) {
            player.sendMessage(ChatColor.RED + "Report not found!");
            return;
        }
        String guiType = this.plugin.getConfig().getString("reports.gui.type", "book").toLowerCase();
        if (guiType.equals("book")) {
            this.openBookGUI(player, report);
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)("Manage Report " + report.getId()));
        ItemStack background = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, background);
        }
        String reporterName = report.isAnonymous() ? "Anonymous" : PlayerNameResolver.resolvePlayerName(report.getReporter());
        String reportedName = PlayerNameResolver.resolvePlayerName(report.getReported());
        if (reporterName == null) {
            reporterName = "Unknown";
        }
        if (reportedName == null) {
            reportedName = "Unknown";
        }
        ItemStack info = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta infoMeta = info.getItemMeta();
        infoMeta.setDisplayName("\u00a7b\u00a7lReport Details");
        infoMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        infoMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        infoMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Reporter: \u00a7f" + reporterName, "\u00a77Reported: \u00a7f" + reportedName, "\u00a77Reason: \u00a7f" + report.getCategory(), "\u00a77Status: \u00a7f" + report.getStatus(), "\u00a77ID: \u00a7f" + report.getId(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500"));
        info.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        info.setItemMeta(infoMeta);
        gui.setItem(22, info);
        ItemStack glass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.setDisplayName(" ");
            glass.setItemMeta(glassMeta);
        }
        for (int slot : new int[]{12, 13, 14, 21, 23, 30, 31, 32}) {
            gui.setItem(slot, glass);
        }
        if (report.getStatus() != Report.ReportStatus.PENDING) {
            ItemStack pending = new ItemStack(Material.HOPPER);
            ItemMeta pendingMeta = pending.getItemMeta();
            pendingMeta.setDisplayName("\u00a76\u00a7lMove to Pending");
            pendingMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Set this report as pending for review.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a76Click to change status"));
            pending.setItemMeta(pendingMeta);
            gui.setItem(45, pending);
        }
        if (report.getStatus() != Report.ReportStatus.RESOLVED) {
            ItemStack resolved = new ItemStack(Material.EMERALD_BLOCK);
            ItemMeta resolvedMeta = resolved.getItemMeta();
            resolvedMeta.setDisplayName("\u00a7a\u00a7lMove to Resolved");
            resolvedMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Mark this report as resolved.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7aClick to change status"));
            resolved.setItemMeta(resolvedMeta);
            gui.setItem(49, resolved);
        }
        if (report.getStatus() != Report.ReportStatus.REJECTED) {
            ItemStack rejected = new ItemStack(Material.BARRIER);
            ItemMeta rejectedMeta = rejected.getItemMeta();
            rejectedMeta.setDisplayName("\u00a7c\u00a7lMove to Rejected");
            rejectedMeta.setLore(List.of("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a77Reject this report as invalid.", "\u00a77Current status: \u00a7f" + report.getStatus(), "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", "\u00a7cClick to change status"));
            rejected.setItemMeta(rejectedMeta);
            gui.setItem(53, rejected);
        }
        player.openInventory(gui);
    }

    private void openBookGUI(Player player, Report report) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        if (meta == null) {
            player.sendMessage("\u00a7cError creating book interface.");
            return;
        }
        meta.setTitle("Report #" + report.getId());
        meta.setAuthor("Report System");
        String reporterName = report.isAnonymous() ? "Anonymous" : PlayerNameResolver.resolvePlayerName(report.getReporter());
        String reportedName = PlayerNameResolver.resolvePlayerName(report.getReported());
        if (reporterName == null) {
            reporterName = "Unknown";
        }
        if (reportedName == null) {
            reportedName = "Unknown";
        }
        String statusColor = switch (report.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case Report.ReportStatus.PENDING -> "\u00a76";
            case Report.ReportStatus.RESOLVED -> "\u00a7a";
            case Report.ReportStatus.REJECTED -> "\u00a7c";
        };
        TextComponent[] page = new TextComponent[]{new TextComponent("\u00a74Report Details \n\n"), new TextComponent("\u00a77Reporter: \u00a7a" + reporterName + "\n"), new TextComponent("\u00a77Reported: \u00a7c" + reportedName + "\n"), new TextComponent("\u00a77Reason: \u00a7c" + report.getCategory() + "\n"), new TextComponent("\u00a77Status: " + statusColor + report.getStatus() + "\n"), new TextComponent("\u00a77ID: \u00a7a" + report.getId() + "\n\n"), new TextComponent("\u00a74Click to change status\n")};
        if (report.getStatus() != Report.ReportStatus.PENDING) {
            TextComponent pending = new TextComponent("\u00a76\u26a0 Set as Pending\n");
            pending.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/shiftreport " + report.getId() + " PENDING"));
            pending.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Set this report as pending for review\n\u00a77Current status: \u00a7f" + report.getStatus()).create()));
            page = this.appendComponent((BaseComponent[])page, (BaseComponent)pending);
        }
        if (report.getStatus() != Report.ReportStatus.RESOLVED) {
            TextComponent resolved = new TextComponent("\u00a7a\u2714 Mark as Resolved\n");
            resolved.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/shiftreport " + report.getId() + " RESOLVED"));
            resolved.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Mark this report as resolved\n\u00a77Current status: \u00a7f" + report.getStatus()).create()));
            page = this.appendComponent((BaseComponent[])page, (BaseComponent)resolved);
        }
        if (report.getStatus() != Report.ReportStatus.REJECTED) {
            TextComponent rejected = new TextComponent("\u00a7c\u2718 Mark as Rejected\n");
            rejected.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/shiftreport " + report.getId() + " REJECTED"));
            rejected.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Reject this report as invalid\n\u00a77Current status: \u00a7f" + report.getStatus()).create()));
            page = this.appendComponent((BaseComponent[])page, (BaseComponent)rejected);
        }
        if (report.getWorld() != null) {
            TextComponent location = new TextComponent("\n\u00a77Location: \u00a7a" + report.getWorld() + " at " + report.getCoordinates() + "\n");
            page = this.appendComponent((BaseComponent[])page, (BaseComponent)location);
        }
        if (report.getEvidenceData() != null && !report.getEvidenceData().isEmpty()) {
            TextComponent evidence = new TextComponent("\u00a77Evidence: \u00a7b" + report.getEvidenceData() + "\n");
            page = this.appendComponent((BaseComponent[])page, (BaseComponent)evidence);
        }
        TextComponent backButton = new TextComponent("\n\u00a77\u00ab Back to Categories");
        backButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reports"));
        backButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Return to report categories").create()));
        page = this.appendComponent((BaseComponent[])page, (BaseComponent)backButton);
        meta.spigot().setPages((BaseComponent[][])new BaseComponent[][]{page});
        book.setItemMeta((ItemMeta)meta);
        player.openBook(book);
    }

    private BaseComponent[] appendComponent(BaseComponent[] components, BaseComponent newComponent) {
        BaseComponent[] newArray = new BaseComponent[components.length + 1];
        System.arraycopy(components, 0, newArray, 0, components.length);
        newArray[components.length] = newComponent;
        return newArray;
    }
}

