/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import dev.aevorinstudios.aevorinReports.gui.VelocityBookGUI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class DebugReportCommand
implements SimpleCommand {
    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            invocation.source().sendMessage((Component)Component.text("Only players can use this command!", (TextColor)NamedTextColor.RED));
            return;
        }
        Player player = (Player)commandSource;
        CharSequence[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            player.sendMessage(((TextComponent)Component.text("Debug Report Commands:", (TextColor)NamedTextColor.GOLD).append(Component.text("\n/debugreport gui", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Opens the report GUI in debug mode", (TextColor)NamedTextColor.GRAY)))).append(Component.text("\n/debugreport submit <reason>", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Simulates submitting a report", (TextColor)NamedTextColor.GRAY))));
            return;
        }
        switch (args[0].toLowerCase()) {
            case "gui": {
                VelocityBookGUI gui = new VelocityBookGUI(player);
                gui.show();
                player.sendMessage((Component)Component.text("Opened report GUI in debug mode", (TextColor)NamedTextColor.GREEN));
                break;
            }
            case "submit": {
                if (args.length < 2) {
                    player.sendMessage((Component)Component.text("Usage: /debugreport submit <reason>", (TextColor)NamedTextColor.RED));
                    return;
                }
                String reason = String.join((CharSequence)" ", args).substring(((String)args[0]).length() + 1);
                player.sendMessage((Component)Component.text("Debug report submitted with reason: " + reason, (TextColor)NamedTextColor.GREEN));
                break;
            }
            default: {
                player.sendMessage((Component)Component.text("Unknown debug command. Use /debugreport for help", (TextColor)NamedTextColor.RED));
            }
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("aevorinreports.debug");
    }
}

