/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.commands;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.java.JavaPlugin;

public class HiddenCommandManager {
    private static final Set<String> HIDDEN_COMMANDS = new HashSet<String>(Arrays.asList("viewreport", "shiftreport"));
    private final JavaPlugin plugin;

    public HiddenCommandManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerHiddenCommands() {
        try {
            Field commandMapField = this.plugin.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(this.plugin.getServer());
            for (String command : HIDDEN_COMMANDS) {
                HiddenCommand hiddenCommand = new HiddenCommand(command);
                commandMap.register(this.plugin.getName().toLowerCase(), (Command)hiddenCommand);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to register hidden commands: " + e.getMessage());
        }
    }

    public static boolean isHiddenCommand(String command) {
        return HIDDEN_COMMANDS.contains(command.toLowerCase());
    }

    private class HiddenCommand
    extends BukkitCommand {
        public HiddenCommand(String name) {
            super(name);
        }

        public boolean execute(CommandSender sender, String commandLabel, String[] args) {
            return true;
        }
    }
}

