/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.config;

public class ErrorHandlerConfig {
    private int maxErrorRepetitions = 3;
    private long suppressionTimeMinutes = 10L;
    private boolean detailedLogging = true;
    private boolean logStackTraces = true;
    private boolean logToSeparateFile = false;
    private String logFilePath = "logs/error.log";
    private boolean categorizeErrors = true;
    private boolean groupSimilarErrors = true;
    private boolean useColoredOutput = true;
    private boolean showErrorCounts = true;

    public static ErrorHandlerConfig createDefault() {
        return new ErrorHandlerConfig();
    }

    public static ErrorHandlerConfig createDevelopmentConfig() {
        ErrorHandlerConfig config = new ErrorHandlerConfig();
        config.setMaxErrorRepetitions(10);
        config.setSuppressionTimeMinutes(5L);
        config.setDetailedLogging(true);
        config.setLogStackTraces(true);
        config.setCategorizeErrors(true);
        config.setGroupSimilarErrors(false);
        return config;
    }

    public static ErrorHandlerConfig createProductionConfig() {
        ErrorHandlerConfig config = new ErrorHandlerConfig();
        config.setMaxErrorRepetitions(2);
        config.setSuppressionTimeMinutes(30L);
        config.setDetailedLogging(false);
        config.setLogStackTraces(true);
        config.setCategorizeErrors(true);
        config.setGroupSimilarErrors(true);
        return config;
    }

    public int getMaxErrorRepetitions() {
        return this.maxErrorRepetitions;
    }

    public long getSuppressionTimeMinutes() {
        return this.suppressionTimeMinutes;
    }

    public boolean isDetailedLogging() {
        return this.detailedLogging;
    }

    public boolean isLogStackTraces() {
        return this.logStackTraces;
    }

    public boolean isLogToSeparateFile() {
        return this.logToSeparateFile;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public boolean isCategorizeErrors() {
        return this.categorizeErrors;
    }

    public boolean isGroupSimilarErrors() {
        return this.groupSimilarErrors;
    }

    public boolean isUseColoredOutput() {
        return this.useColoredOutput;
    }

    public boolean isShowErrorCounts() {
        return this.showErrorCounts;
    }

    public void setMaxErrorRepetitions(int maxErrorRepetitions) {
        this.maxErrorRepetitions = maxErrorRepetitions;
    }

    public void setSuppressionTimeMinutes(long suppressionTimeMinutes) {
        this.suppressionTimeMinutes = suppressionTimeMinutes;
    }

    public void setDetailedLogging(boolean detailedLogging) {
        this.detailedLogging = detailedLogging;
    }

    public void setLogStackTraces(boolean logStackTraces) {
        this.logStackTraces = logStackTraces;
    }

    public void setLogToSeparateFile(boolean logToSeparateFile) {
        this.logToSeparateFile = logToSeparateFile;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public void setCategorizeErrors(boolean categorizeErrors) {
        this.categorizeErrors = categorizeErrors;
    }

    public void setGroupSimilarErrors(boolean groupSimilarErrors) {
        this.groupSimilarErrors = groupSimilarErrors;
    }

    public void setUseColoredOutput(boolean useColoredOutput) {
        this.useColoredOutput = useColoredOutput;
    }

    public void setShowErrorCounts(boolean showErrorCounts) {
        this.showErrorCounts = showErrorCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorHandlerConfig)) {
            return false;
        }
        ErrorHandlerConfig other = (ErrorHandlerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxErrorRepetitions() != other.getMaxErrorRepetitions()) {
            return false;
        }
        if (this.getSuppressionTimeMinutes() != other.getSuppressionTimeMinutes()) {
            return false;
        }
        if (this.isDetailedLogging() != other.isDetailedLogging()) {
            return false;
        }
        if (this.isLogStackTraces() != other.isLogStackTraces()) {
            return false;
        }
        if (this.isLogToSeparateFile() != other.isLogToSeparateFile()) {
            return false;
        }
        if (this.isCategorizeErrors() != other.isCategorizeErrors()) {
            return false;
        }
        if (this.isGroupSimilarErrors() != other.isGroupSimilarErrors()) {
            return false;
        }
        if (this.isUseColoredOutput() != other.isUseColoredOutput()) {
            return false;
        }
        if (this.isShowErrorCounts() != other.isShowErrorCounts()) {
            return false;
        }
        String this$logFilePath = this.getLogFilePath();
        String other$logFilePath = other.getLogFilePath();
        return !(this$logFilePath == null ? other$logFilePath != null : !this$logFilePath.equals(other$logFilePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorHandlerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxErrorRepetitions();
        long $suppressionTimeMinutes = this.getSuppressionTimeMinutes();
        result = result * 59 + (int)($suppressionTimeMinutes >>> 32 ^ $suppressionTimeMinutes);
        result = result * 59 + (this.isDetailedLogging() ? 79 : 97);
        result = result * 59 + (this.isLogStackTraces() ? 79 : 97);
        result = result * 59 + (this.isLogToSeparateFile() ? 79 : 97);
        result = result * 59 + (this.isCategorizeErrors() ? 79 : 97);
        result = result * 59 + (this.isGroupSimilarErrors() ? 79 : 97);
        result = result * 59 + (this.isUseColoredOutput() ? 79 : 97);
        result = result * 59 + (this.isShowErrorCounts() ? 79 : 97);
        String $logFilePath = this.getLogFilePath();
        result = result * 59 + ($logFilePath == null ? 43 : $logFilePath.hashCode());
        return result;
    }

    public String toString() {
        return "ErrorHandlerConfig(maxErrorRepetitions=" + this.getMaxErrorRepetitions() + ", suppressionTimeMinutes=" + this.getSuppressionTimeMinutes() + ", detailedLogging=" + this.isDetailedLogging() + ", logStackTraces=" + this.isLogStackTraces() + ", logToSeparateFile=" + this.isLogToSeparateFile() + ", logFilePath=" + this.getLogFilePath() + ", categorizeErrors=" + this.isCategorizeErrors() + ", groupSimilarErrors=" + this.isGroupSimilarErrors() + ", useColoredOutput=" + this.isUseColoredOutput() + ", showErrorCounts=" + this.isShowErrorCounts() + ")";
    }
}

