/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.config;

import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class GUIConfiguration {
    private static GUIConfiguration instance;
    private String titleColor;
    private String numberColor;
    private String playerNameColor;
    private String separatorColor;
    private String pendingColor;
    private String inProgressColor;
    private String resolvedColor;
    private String rejectedColor;
    private String afterNumber;
    private String afterName;
    private String beforeLine;
    private String afterLine;
    private String groupBullet;
    private String groupCountOpen;
    private String groupCountClose;
    private String separatorLine;
    private int reportsPerPage;

    private GUIConfiguration() {
        this.loadDefaults();
    }

    public static GUIConfiguration getInstance() {
        if (instance == null) {
            instance = new GUIConfiguration();
        }
        return instance;
    }

    private void loadDefaults() {
        this.titleColor = "&6";
        this.numberColor = "&6";
        this.playerNameColor = "&f";
        this.separatorColor = "&8";
        this.pendingColor = "&d";
        this.inProgressColor = "&b";
        this.resolvedColor = "&a";
        this.rejectedColor = "&c";
        this.afterNumber = " ";
        this.afterName = " ";
        this.beforeLine = "";
        this.afterLine = "";
        this.groupBullet = "\u27a4 ";
        this.groupCountOpen = "(";
        this.groupCountClose = ")";
        this.separatorLine = "\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af";
        this.reportsPerPage = 5;
    }

    public void loadConfig(InputStream configFile) {
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(configFile);
        if (config != null && config.containsKey("gui")) {
            Map guiConfig = (Map)config.get("gui");
            if (guiConfig.containsKey("colors")) {
                Map colors = (Map)guiConfig.get("colors");
                this.titleColor = colors.getOrDefault("title", this.titleColor);
                this.numberColor = colors.getOrDefault("number", this.numberColor);
                this.playerNameColor = colors.getOrDefault("player_name", this.playerNameColor);
                this.separatorColor = colors.getOrDefault("separator", this.separatorColor);
                if (colors.containsKey("status")) {
                    Map statusColors = (Map)colors.get("status");
                    this.pendingColor = statusColors.getOrDefault("pending", this.pendingColor);
                    this.inProgressColor = statusColors.getOrDefault("in_progress", this.inProgressColor);
                    this.resolvedColor = statusColors.getOrDefault("resolved", this.resolvedColor);
                    this.rejectedColor = statusColors.getOrDefault("rejected", this.rejectedColor);
                }
            }
            if (guiConfig.containsKey("spacing")) {
                Map spacing = (Map)guiConfig.get("spacing");
                this.afterNumber = spacing.getOrDefault("after_number", this.afterNumber);
                this.afterName = spacing.getOrDefault("after_name", this.afterName);
                this.beforeLine = spacing.getOrDefault("before_line", this.beforeLine);
                this.afterLine = spacing.getOrDefault("after_line", this.afterLine);
            }
            if (guiConfig.containsKey("symbols")) {
                Map symbols = (Map)guiConfig.get("symbols");
                this.groupBullet = symbols.getOrDefault("group_bullet", this.groupBullet);
                this.groupCountOpen = symbols.getOrDefault("group_count_open", this.groupCountOpen);
                this.groupCountClose = symbols.getOrDefault("group_count_close", this.groupCountClose);
            }
            if (guiConfig.containsKey("layout")) {
                Map layout = (Map)guiConfig.get("layout");
                this.separatorLine = layout.getOrDefault("separator_line", this.separatorLine);
                this.reportsPerPage = layout.getOrDefault("reports_per_page", this.reportsPerPage);
            }
        }
    }

    public String getTitleColor() {
        return this.titleColor;
    }

    public String getNumberColor() {
        return this.numberColor;
    }

    public String getPlayerNameColor() {
        return this.playerNameColor;
    }

    public String getSeparatorColor() {
        return this.separatorColor;
    }

    public String getPendingColor() {
        return this.pendingColor;
    }

    public String getInProgressColor() {
        return this.inProgressColor;
    }

    public String getResolvedColor() {
        return this.resolvedColor;
    }

    public String getRejectedColor() {
        return this.rejectedColor;
    }

    public String getAfterNumber() {
        return this.afterNumber;
    }

    public String getAfterName() {
        return this.afterName;
    }

    public String getBeforeLine() {
        return this.beforeLine;
    }

    public String getAfterLine() {
        return this.afterLine;
    }

    public String getGroupBullet() {
        return this.groupBullet;
    }

    public String getGroupCountOpen() {
        return this.groupCountOpen;
    }

    public String getGroupCountClose() {
        return this.groupCountClose;
    }

    public String getSeparatorLine() {
        return this.separatorLine;
    }

    public int getReportsPerPage() {
        return this.reportsPerPage;
    }

    public String getSymbol(String symbolName) {
        return switch (symbolName) {
            case "group_bullet" -> this.groupBullet;
            case "group_count_open" -> this.groupCountOpen;
            case "group_count_close" -> this.groupCountClose;
            default -> throw new IllegalArgumentException("Unknown symbol: " + symbolName);
        };
    }
}

