/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.config;

import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class MessagesConfiguration {
    private static MessagesConfiguration instance;
    private String noPermission;
    private String playerOnly;
    private String invalidGroup;
    private String noReports;
    private String mainTitle;
    private String groupTitle;
    private String viewDetails;
    private String viewGroup;
    private String numberPrefix;
    private String statusFormat;
    private String separator;

    private MessagesConfiguration() {
        this.loadDefaults();
    }

    public static MessagesConfiguration getInstance() {
        if (instance == null) {
            instance = new MessagesConfiguration();
        }
        return instance;
    }

    private void loadDefaults() {
        this.noPermission = "&cYou don't have permission to use this command!";
        this.playerOnly = "&cOnly players can use this command!";
        this.invalidGroup = "&cInvalid group! Available groups: PENDING, IN_PROGRESS, RESOLVED, REJECTED";
        this.noReports = "&cNo {status} reports found.";
        this.mainTitle = "&6Report Groups";
        this.groupTitle = "&6{status} Reports";
        this.viewDetails = "Click to view report details";
        this.viewGroup = "Click to view {count} {status} reports";
        this.numberPrefix = "#";
        this.statusFormat = "[{status}]";
        this.separator = "\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af";
    }

    public void loadConfig(InputStream configFile) {
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(configFile);
        if (config != null && config.containsKey("messages")) {
            Map messages = (Map)config.get("messages");
            if (messages.containsKey("errors")) {
                Map errors = (Map)messages.get("errors");
                this.noPermission = errors.getOrDefault("no-permission", this.noPermission);
                this.playerOnly = errors.getOrDefault("player-only", this.playerOnly);
                this.invalidGroup = errors.getOrDefault("invalid-group", this.invalidGroup);
                this.noReports = errors.getOrDefault("no-reports", this.noReports);
            }
            if (messages.containsKey("book")) {
                Map book = (Map)messages.get("book");
                this.mainTitle = book.getOrDefault("main-title", this.mainTitle);
                this.groupTitle = book.getOrDefault("group-title", this.groupTitle);
                this.viewDetails = book.getOrDefault("view-details", this.viewDetails);
                this.viewGroup = book.getOrDefault("view-group", this.viewGroup);
            }
            if (messages.containsKey("report-format")) {
                Map format = (Map)messages.get("report-format");
                this.numberPrefix = format.getOrDefault("number-prefix", this.numberPrefix);
                this.statusFormat = format.getOrDefault("status-format", this.statusFormat);
                this.separator = format.getOrDefault("separator", this.separator);
            }
        }
    }

    public String getNoPermission() {
        return this.noPermission;
    }

    public String getPlayerOnly() {
        return this.playerOnly;
    }

    public String getInvalidGroup() {
        return this.invalidGroup;
    }

    public String getNoReports() {
        return this.noReports;
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public String getGroupTitle() {
        return this.groupTitle;
    }

    public String getViewDetails() {
        return this.viewDetails;
    }

    public String getViewGroup() {
        return this.viewGroup;
    }

    public String getNumberPrefix() {
        return this.numberPrefix;
    }

    public String getStatusFormat() {
        return this.statusFormat;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String formatNoReports(String status) {
        return this.noReports.replace("{status}", status);
    }

    public String formatGroupTitle(String status) {
        return this.groupTitle.replace("{status}", status);
    }

    public String formatViewGroup(int count, String status) {
        return this.viewGroup.replace("{count}", String.valueOf(count)).replace("{status}", status);
    }

    public String formatStatusFormat(String status) {
        return this.statusFormat.replace("{status}", status);
    }

    public String getMessage(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        String[] parts = path.split("\\.");
        if (parts.length < 2) {
            return "";
        }
        switch (parts[1]) {
            case "errors": {
                switch (parts[2]) {
                    case "no-permission": {
                        return this.noPermission;
                    }
                    case "player-only": {
                        return this.playerOnly;
                    }
                    case "invalid-group": {
                        return this.invalidGroup;
                    }
                    case "no-reports": {
                        return this.noReports;
                    }
                }
                return "";
            }
            case "book": {
                switch (parts[2]) {
                    case "main-title": {
                        return this.mainTitle;
                    }
                    case "group-title": {
                        return this.groupTitle;
                    }
                    case "view-details": {
                        return this.viewDetails;
                    }
                    case "view-group": {
                        return this.viewGroup;
                    }
                }
                return "";
            }
            case "report-format": {
                switch (parts[2]) {
                    case "number-prefix": {
                        return this.numberPrefix;
                    }
                    case "status-format": {
                        return this.statusFormat;
                    }
                    case "separator": {
                        return this.separator;
                    }
                }
                return "";
            }
        }
        return "";
    }
}

