/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class ReportConfiguration {
    private static ReportConfiguration instance;
    private List<String> categories = new ArrayList<String>();
    private int cooldown;
    private int maxActiveReports;
    private int minDescriptionLength;
    private int maxDescriptionLength;

    private ReportConfiguration() {
        this.loadDefaults();
    }

    public static ReportConfiguration getInstance() {
        if (instance == null) {
            instance = new ReportConfiguration();
        }
        return instance;
    }

    private void loadDefaults() {
        this.categories.add("Hacking");
        this.categories.add("Griefing");
        this.categories.add("Chat Abuse");
        this.categories.add("Other");
        this.cooldown = 300;
        this.maxActiveReports = 3;
        this.minDescriptionLength = 10;
        this.maxDescriptionLength = 500;
    }

    public void loadConfig(InputStream configFile) {
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(configFile);
        if (config != null && config.containsKey("reports")) {
            Map reportsConfig = (Map)config.get("reports");
            if (reportsConfig.containsKey("categories")) {
                this.categories = (List)reportsConfig.get("categories");
            }
            if (reportsConfig.containsKey("cooldown")) {
                this.cooldown = (Integer)reportsConfig.get("cooldown");
            }
            if (reportsConfig.containsKey("max-active-reports")) {
                this.maxActiveReports = (Integer)reportsConfig.get("max-active-reports");
            }
            if (reportsConfig.containsKey("min-description-length")) {
                this.minDescriptionLength = (Integer)reportsConfig.get("min-description-length");
            }
            if (reportsConfig.containsKey("max-description-length")) {
                this.maxDescriptionLength = (Integer)reportsConfig.get("max-description-length");
            }
        }
    }

    public List<String> getCategories() {
        return new ArrayList<String>(this.categories);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMaxActiveReports() {
        return this.maxActiveReports;
    }

    public int getMinDescriptionLength() {
        return this.minDescriptionLength;
    }

    public int getMaxDescriptionLength() {
        return this.maxDescriptionLength;
    }
}

