/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.gui;

import dev.aevorinstudios.aevorinReports.config.GUIConfiguration;
import dev.aevorinstudios.aevorinReports.config.MessagesConfiguration;
import dev.aevorinstudios.aevorinReports.config.ReportConfiguration;
import dev.aevorinstudios.aevorinReports.reports.Report;
import dev.aevorinstudios.aevorinReports.utils.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;

public class BookGUI {
    private final List<Component> pages;
    private final Player viewer;
    private int currentPage;
    private final ReportConfiguration reportConfig;
    private final GUIConfiguration guiConfig;
    private final MessagesConfiguration messagesConfig;

    public BookGUI(Player viewer) {
        this.viewer = viewer;
        this.pages = new ArrayList<Component>();
        this.currentPage = 0;
        this.reportConfig = ReportConfiguration.getInstance();
        this.guiConfig = GUIConfiguration.getInstance();
        this.messagesConfig = MessagesConfiguration.getInstance();
        this.initializePages();
    }

    private void initializePages() {
        Component firstPage = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text(this.messagesConfig.getMainTitle(), ColorUtils.parseColor(this.guiConfig.getTitleColor())).decoration(TextDecoration.BOLD, true))).append(Component.newline())).append(Component.text(this.guiConfig.getSeparatorLine(), ColorUtils.parseColor(this.guiConfig.getSeparatorColor())))).append(Component.newline());
        List<String> categories = this.reportConfig.getCategories();
        for (String category : categories) {
            firstPage = firstPage.append(this.createReportOption(category)).append(Component.newline());
        }
        firstPage = firstPage.append(Component.text(this.guiConfig.getSeparatorLine(), ColorUtils.parseColor(this.guiConfig.getSeparatorColor())));
        this.pages.add(firstPage);
    }

    private Component createReportOption(String reason) {
        return Component.text(this.guiConfig.getGroupBullet(), ColorUtils.parseColor(this.guiConfig.getSeparatorColor())).append((Component)((TextComponent)Component.text(reason, ColorUtils.parseColor(this.guiConfig.getPlayerNameColor())).clickEvent(ClickEvent.runCommand("/report " + reason))).hoverEvent(HoverEvent.showText(Component.text(this.messagesConfig.getViewDetails(), ColorUtils.parseColor(this.guiConfig.getNumberColor())))));
    }

    public void addReportPage(List<Report> reports) {
        Component page = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text(this.messagesConfig.getGroupTitle(), ColorUtils.parseColor(this.guiConfig.getTitleColor())).decoration(TextDecoration.BOLD, true))).append(Component.newline())).append(Component.text(this.guiConfig.getSeparatorLine(), ColorUtils.parseColor(this.guiConfig.getSeparatorColor())))).append(Component.newline());
        int count = 0;
        for (Report report : reports) {
            if (count >= this.guiConfig.getReportsPerPage()) {
                this.pages.add(page);
                page = Component.empty();
                count = 0;
            }
            String statusColor = switch (report.getStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case Report.ReportStatus.PENDING -> this.guiConfig.getPendingColor();
                case Report.ReportStatus.RESOLVED -> this.guiConfig.getResolvedColor();
                case Report.ReportStatus.REJECTED -> this.guiConfig.getRejectedColor();
            };
            page = page.append(Component.text(this.messagesConfig.getNumberPrefix() + report.getId(), ColorUtils.parseColor(this.guiConfig.getNumberColor()))).append(Component.text(this.guiConfig.getAfterNumber())).append(Component.text(this.messagesConfig.formatStatusFormat(report.getStatus().name()), ColorUtils.parseColor(statusColor))).append(Component.text(this.guiConfig.getAfterName())).append(Component.text(report.getCategory(), ColorUtils.parseColor(this.guiConfig.getPlayerNameColor()))).append(Component.newline());
            ++count;
        }
        if (count > 0) {
            page = page.append(Component.text(this.guiConfig.getSeparatorLine(), ColorUtils.parseColor(this.guiConfig.getSeparatorColor())));
            this.pages.add(page);
        }
    }

    public void show() {
        if (this.currentPage >= 0 && this.currentPage < this.pages.size()) {
            this.viewer.sendMessage(this.pages.get(this.currentPage));
        }
    }

    public void nextPage() {
        if (this.currentPage < this.pages.size() - 1) {
            ++this.currentPage;
            this.show();
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.show();
        }
    }
}

