/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.notification;

import dev.aevorinstudios.aevorinReports.config.Settings;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.util.Collection;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NotificationManager {
    private final Settings settings;
    private final MiniMessage miniMessage;

    public NotificationManager(Settings settings) {
        this.settings = settings;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public void sendNewReportNotification(Report report) {
        if (!this.settings.getNotifications().isNewReport()) {
            return;
        }
        String message = this.settings.getMessages().getReportNotification().replace("{reporter}", report.getReporter().toString()).replace("{reported}", report.getReported().toString()).replace("{category}", report.getCategory());
        this.sendToStaff(message, true);
    }

    public void sendStatusChangeNotification(Report report) {
        if (!this.settings.getNotifications().isStatusChange()) {
            return;
        }
        String message = this.settings.getMessages().getReportStatusChange().replace("{id}", String.valueOf(report.getId())).replace("{status}", report.getStatus().toString());
        this.sendToStaff(message, true);
    }

    private void sendToStaff(String message, boolean playSound) {
        Collection players = Bukkit.getOnlinePlayers();
        Object component = this.miniMessage.deserialize(this.settings.getNotifications().getPrefix() + message);
        for (Player player : players) {
            if (!player.hasPermission("aevorinreports.notifications")) continue;
            player.sendMessage((Component)component);
            if (!playSound || this.settings.getNotifications().getSound() == null) continue;
            player.playSound(player.getLocation(), this.settings.getNotifications().getSound(), 1.0f, 1.0f);
        }
    }

    public void sendMessage(Audience audience, String message) {
        Object component = this.miniMessage.deserialize(this.settings.getNotifications().getPrefix() + message);
        audience.sendMessage((Component)component);
    }

    public void sendMessage(Audience audience, Component component) {
        Component prefixedComponent = this.miniMessage.deserialize(this.settings.getNotifications().getPrefix()).append(component);
        audience.sendMessage(prefixedComponent);
    }
}

