/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.performance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.aevorinstudios.aevorinReports.config.ConfigManager;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PerformanceManager {
    private final ConfigManager configManager;
    private Cache<Long, Report> reportCache;
    private ExecutorService asyncExecutor;
    private static final int THREAD_POOL_SIZE = 3;

    public void initialize() {
        this.initializeCache();
        this.initializeAsyncExecutor();
        this.startBackgroundTasks();
    }

    private void initializeCache() {
        if (this.configManager.getConfig().getPerformance().isEnableCaching()) {
            this.reportCache = CacheBuilder.newBuilder().maximumSize((long)this.configManager.getConfig().getPerformance().getMaxCacheSize()).expireAfterWrite((long)this.configManager.getConfig().getPerformance().getCacheDuration(), TimeUnit.MINUTES).build();
        }
    }

    private void initializeAsyncExecutor() {
        if (this.configManager.getConfig().getPerformance().isAsyncProcessing()) {
            this.asyncExecutor = Executors.newFixedThreadPool(3);
        }
    }

    private void startBackgroundTasks() {
        if (this.configManager.getConfig().getPerformance().isAsyncProcessing()) {
            int interval = this.configManager.getConfig().getPerformance().getBackgroundTaskInterval();
            this.asyncExecutor.submit(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep((long)interval * 1000L);
                        this.cleanupCache();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            });
        }
    }

    public void submitAsyncTask(Runnable task) {
        if (this.asyncExecutor != null && !this.asyncExecutor.isShutdown()) {
            this.asyncExecutor.submit(task);
        } else {
            task.run();
        }
    }

    public <T> void processBatch(List<T> items, BatchProcessor<T> processor) {
        if (this.configManager.getConfig().getPerformance().isAsyncProcessing()) {
            int batchSize = this.configManager.getConfig().getPerformance().getBatchSize();
            for (int i = 0; i < items.size(); i += batchSize) {
                int end = Math.min(items.size(), i + batchSize);
                List batch = items.subList(i, end);
                this.submitAsyncTask(() -> processor.processBatch(batch));
            }
        } else {
            processor.processBatch(items);
        }
    }

    public void cacheReport(Report report) {
        if (this.reportCache != null) {
            this.reportCache.put((Object)report.getId(), (Object)report);
        }
    }

    public Report getCachedReport(long reportId) {
        return this.reportCache != null ? (Report)this.reportCache.getIfPresent((Object)reportId) : null;
    }

    private void cleanupCache() {
        if (this.reportCache != null) {
            this.reportCache.cleanUp();
        }
    }

    public void shutdown() {
        if (this.asyncExecutor != null) {
            this.asyncExecutor.shutdown();
            try {
                if (!this.asyncExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.asyncExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.asyncExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public PerformanceManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @FunctionalInterface
    public static interface BatchProcessor<T> {
        public void processBatch(List<T> var1);
    }
}

