/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.performance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.aevorinstudios.aevorinReports.config.VelocityConfigManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class VelocityPerformanceManager {
    private final ProxyServer server;
    private final VelocityConfigManager config;
    private final Logger logger;
    private Cache<String, Object> reportCache;
    private ExecutorService asyncExecutor;
    private BlockingQueue<Runnable> asyncQueue;

    public VelocityPerformanceManager(ProxyServer server, VelocityConfigManager config, Logger logger) {
        this.server = server;
        this.config = config;
        this.logger = logger;
        this.initializeCache();
        this.initializeAsyncProcessing();
    }

    private void initializeCache() {
        if (this.config.isCacheEnabled()) {
            this.reportCache = CacheBuilder.newBuilder().maximumSize((long)this.config.getMaxCachedReports()).expireAfterWrite((long)this.config.getCacheExpiration(), TimeUnit.MINUTES).build();
            this.logger.info("Report cache initialized with size " + this.config.getMaxCachedReports());
        }
    }

    private void initializeAsyncProcessing() {
        if (this.config.isAsyncProcessingEnabled()) {
            this.asyncQueue = new LinkedBlockingQueue<Runnable>(this.config.getMaxAsyncQueueSize());
            this.asyncExecutor = new ThreadPoolExecutor(this.config.getAsyncThreadPoolSize(), this.config.getAsyncThreadPoolSize(), 60L, TimeUnit.SECONDS, this.asyncQueue, new ThreadPoolExecutor.CallerRunsPolicy());
            this.logger.info("Async processing initialized with " + this.config.getAsyncThreadPoolSize() + " threads");
        }
    }

    public void submitAsyncTask(Runnable task) {
        if (this.asyncExecutor != null && !this.asyncExecutor.isShutdown()) {
            try {
                this.asyncExecutor.submit(task);
            }
            catch (RejectedExecutionException e) {
                this.logger.warning("Async task rejected: Queue full");
                task.run();
            }
        } else {
            task.run();
        }
    }

    public void putInCache(String key, Object value) {
        if (this.reportCache != null) {
            this.reportCache.put((Object)key, value);
        }
    }

    public <T> T getFromCache(String key) {
        return (T)(this.reportCache != null ? this.reportCache.getIfPresent((Object)key) : null);
    }

    public void invalidateCache(String key) {
        if (this.reportCache != null) {
            this.reportCache.invalidate((Object)key);
        }
    }

    public void cleanup() {
        if (this.asyncExecutor != null) {
            this.asyncExecutor.shutdown();
            try {
                if (!this.asyncExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.asyncExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.asyncExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.reportCache != null) {
            this.reportCache.invalidateAll();
        }
    }
}

