/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.reports;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;

public class Report {
    private Long id;
    private UUID reporterUuid;
    private UUID reportedUuid;
    private String reporterName;
    private String reportedPlayerName;
    private String reason;
    private String serverName;
    private ReportStatus status;
    private String lastUpdatedBy;
    private boolean isAnonymous;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
    private String evidenceData;
    private String coordinates;
    private String world;

    public boolean canTransitionTo(ReportStatus newStatus, ConfigurationSection statusConfig) {
        if (this.status == newStatus) {
            return false;
        }
        String currentStatusKey = this.status.name().toLowerCase();
        ConfigurationSection currentStatusSection = statusConfig.getConfigurationSection("types." + currentStatusKey);
        if (currentStatusSection == null) {
            return false;
        }
        List allowedTransitions = currentStatusSection.getStringList("transitions");
        return allowedTransitions.contains(newStatus.name().toLowerCase());
    }

    public boolean isActive() {
        return this.status == ReportStatus.PENDING;
    }

    public boolean canBeUpdated() {
        return this.status != ReportStatus.RESOLVED && this.status != ReportStatus.REJECTED;
    }

    public UUID getReporter() {
        return this.reporterUuid;
    }

    public UUID getReported() {
        return this.reportedUuid;
    }

    public String getCategory() {
        return this.reason;
    }

    Report(Long id, UUID reporterUuid, UUID reportedUuid, String reporterName, String reportedPlayerName, String reason, String serverName, ReportStatus status, String lastUpdatedBy, boolean isAnonymous, LocalDateTime createdAt, LocalDateTime updatedAt, String evidenceData, String coordinates, String world) {
        this.id = id;
        this.reporterUuid = reporterUuid;
        this.reportedUuid = reportedUuid;
        this.reporterName = reporterName;
        this.reportedPlayerName = reportedPlayerName;
        this.reason = reason;
        this.serverName = serverName;
        this.status = status;
        this.lastUpdatedBy = lastUpdatedBy;
        this.isAnonymous = isAnonymous;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.evidenceData = evidenceData;
        this.coordinates = coordinates;
        this.world = world;
    }

    public static ReportBuilder builder() {
        return new ReportBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public UUID getReporterUuid() {
        return this.reporterUuid;
    }

    public UUID getReportedUuid() {
        return this.reportedUuid;
    }

    public String getReporterName() {
        return this.reporterName;
    }

    public String getReportedPlayerName() {
        return this.reportedPlayerName;
    }

    public String getReason() {
        return this.reason;
    }

    public String getServerName() {
        return this.serverName;
    }

    public ReportStatus getStatus() {
        return this.status;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getEvidenceData() {
        return this.evidenceData;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public String getWorld() {
        return this.world;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReporterUuid(UUID reporterUuid) {
        this.reporterUuid = reporterUuid;
    }

    public void setReportedUuid(UUID reportedUuid) {
        this.reportedUuid = reportedUuid;
    }

    public void setReporterName(String reporterName) {
        this.reporterName = reporterName;
    }

    public void setReportedPlayerName(String reportedPlayerName) {
        this.reportedPlayerName = reportedPlayerName;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setStatus(ReportStatus status) {
        this.status = status;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public void setAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setEvidenceData(String evidenceData) {
        this.evidenceData = evidenceData;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        Report other = (Report)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAnonymous() != other.isAnonymous()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$reporterUuid = this.getReporterUuid();
        UUID other$reporterUuid = other.getReporterUuid();
        if (this$reporterUuid == null ? other$reporterUuid != null : !((Object)this$reporterUuid).equals(other$reporterUuid)) {
            return false;
        }
        UUID this$reportedUuid = this.getReportedUuid();
        UUID other$reportedUuid = other.getReportedUuid();
        if (this$reportedUuid == null ? other$reportedUuid != null : !((Object)this$reportedUuid).equals(other$reportedUuid)) {
            return false;
        }
        String this$reporterName = this.getReporterName();
        String other$reporterName = other.getReporterName();
        if (this$reporterName == null ? other$reporterName != null : !this$reporterName.equals(other$reporterName)) {
            return false;
        }
        String this$reportedPlayerName = this.getReportedPlayerName();
        String other$reportedPlayerName = other.getReportedPlayerName();
        if (this$reportedPlayerName == null ? other$reportedPlayerName != null : !this$reportedPlayerName.equals(other$reportedPlayerName)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        ReportStatus this$status = this.getStatus();
        ReportStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$lastUpdatedBy = this.getLastUpdatedBy();
        String other$lastUpdatedBy = other.getLastUpdatedBy();
        if (this$lastUpdatedBy == null ? other$lastUpdatedBy != null : !this$lastUpdatedBy.equals(other$lastUpdatedBy)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$evidenceData = this.getEvidenceData();
        String other$evidenceData = other.getEvidenceData();
        if (this$evidenceData == null ? other$evidenceData != null : !this$evidenceData.equals(other$evidenceData)) {
            return false;
        }
        String this$coordinates = this.getCoordinates();
        String other$coordinates = other.getCoordinates();
        if (this$coordinates == null ? other$coordinates != null : !this$coordinates.equals(other$coordinates)) {
            return false;
        }
        String this$world = this.getWorld();
        String other$world = other.getWorld();
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Report;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnonymous() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $reporterUuid = this.getReporterUuid();
        result = result * 59 + ($reporterUuid == null ? 43 : ((Object)$reporterUuid).hashCode());
        UUID $reportedUuid = this.getReportedUuid();
        result = result * 59 + ($reportedUuid == null ? 43 : ((Object)$reportedUuid).hashCode());
        String $reporterName = this.getReporterName();
        result = result * 59 + ($reporterName == null ? 43 : $reporterName.hashCode());
        String $reportedPlayerName = this.getReportedPlayerName();
        result = result * 59 + ($reportedPlayerName == null ? 43 : $reportedPlayerName.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        ReportStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $lastUpdatedBy = this.getLastUpdatedBy();
        result = result * 59 + ($lastUpdatedBy == null ? 43 : $lastUpdatedBy.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $evidenceData = this.getEvidenceData();
        result = result * 59 + ($evidenceData == null ? 43 : $evidenceData.hashCode());
        String $coordinates = this.getCoordinates();
        result = result * 59 + ($coordinates == null ? 43 : $coordinates.hashCode());
        String $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    public String toString() {
        return "Report(id=" + this.getId() + ", reporterUuid=" + this.getReporterUuid() + ", reportedUuid=" + this.getReportedUuid() + ", reporterName=" + this.getReporterName() + ", reportedPlayerName=" + this.getReportedPlayerName() + ", reason=" + this.getReason() + ", serverName=" + this.getServerName() + ", status=" + this.getStatus() + ", lastUpdatedBy=" + this.getLastUpdatedBy() + ", isAnonymous=" + this.isAnonymous() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", evidenceData=" + this.getEvidenceData() + ", coordinates=" + this.getCoordinates() + ", world=" + this.getWorld() + ")";
    }

    public static enum ReportStatus {
        PENDING,
        RESOLVED,
        REJECTED;

    }

    public static class ReportBuilder {
        private Long id;
        private UUID reporterUuid;
        private UUID reportedUuid;
        private String reporterName;
        private String reportedPlayerName;
        private String reason;
        private String serverName;
        private ReportStatus status;
        private String lastUpdatedBy;
        private boolean isAnonymous;
        private LocalDateTime createdAt;
        private LocalDateTime updatedAt;
        private String evidenceData;
        private String coordinates;
        private String world;

        ReportBuilder() {
        }

        public ReportBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ReportBuilder reporterUuid(UUID reporterUuid) {
            this.reporterUuid = reporterUuid;
            return this;
        }

        public ReportBuilder reportedUuid(UUID reportedUuid) {
            this.reportedUuid = reportedUuid;
            return this;
        }

        public ReportBuilder reporterName(String reporterName) {
            this.reporterName = reporterName;
            return this;
        }

        public ReportBuilder reportedPlayerName(String reportedPlayerName) {
            this.reportedPlayerName = reportedPlayerName;
            return this;
        }

        public ReportBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public ReportBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public ReportBuilder status(ReportStatus status) {
            this.status = status;
            return this;
        }

        public ReportBuilder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public ReportBuilder isAnonymous(boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        public ReportBuilder createdAt(LocalDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ReportBuilder updatedAt(LocalDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ReportBuilder evidenceData(String evidenceData) {
            this.evidenceData = evidenceData;
            return this;
        }

        public ReportBuilder coordinates(String coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public ReportBuilder world(String world) {
            this.world = world;
            return this;
        }

        public Report build() {
            return new Report(this.id, this.reporterUuid, this.reportedUuid, this.reporterName, this.reportedPlayerName, this.reason, this.serverName, this.status, this.lastUpdatedBy, this.isAnonymous, this.createdAt, this.updatedAt, this.evidenceData, this.coordinates, this.world);
        }

        public String toString() {
            return "Report.ReportBuilder(id=" + this.id + ", reporterUuid=" + this.reporterUuid + ", reportedUuid=" + this.reportedUuid + ", reporterName=" + this.reporterName + ", reportedPlayerName=" + this.reportedPlayerName + ", reason=" + this.reason + ", serverName=" + this.serverName + ", status=" + this.status + ", lastUpdatedBy=" + this.lastUpdatedBy + ", isAnonymous=" + this.isAnonymous + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", evidenceData=" + this.evidenceData + ", coordinates=" + this.coordinates + ", world=" + this.world + ")";
        }
    }
}

