/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.reports;

import dev.aevorinstudios.aevorinReports.reports.Report;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ReportManager {
    private static ReportManager instance;
    private final Map<Long, Report> reports = new ConcurrentHashMap<Long, Report>();

    private ReportManager() {
    }

    public static ReportManager getInstance() {
        if (instance == null) {
            instance = new ReportManager();
        }
        return instance;
    }

    public Report createReport(UUID reporterId, String reporterName, UUID reportedId, String reportedName, String description, String serverName) {
        Report report = Report.builder().id(System.currentTimeMillis()).reporterUuid(reporterId).reportedUuid(reportedId).reporterName(reporterName).reportedPlayerName(reportedName).reason(description).serverName(serverName).status(Report.ReportStatus.PENDING).isAnonymous(false).createdAt(LocalDateTime.now()).updatedAt(LocalDateTime.now()).build();
        this.reports.put(report.getId(), report);
        return report;
    }

    public Report getReport(Long reportId) {
        return this.reports.get(reportId);
    }

    public boolean updateReportStatus(Long reportId, Report.ReportStatus newStatus) {
        Report report = this.reports.get(reportId);
        if (report != null) {
            report.setStatus(newStatus);
            return true;
        }
        return false;
    }

    public void deleteReport(Long reportId) {
        this.reports.remove(reportId);
    }

    public Map<Long, Report> getAllReports() {
        return new HashMap<Long, Report>(this.reports);
    }

    public void clearReports() {
        this.reports.clear();
    }
}

