/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.storage;

import dev.aevorinstudios.aevorinReports.config.Settings;
import dev.aevorinstudios.aevorinReports.database.DatabaseManager;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StorageManager {
    private final Settings settings;
    private final DatabaseManager databaseManager;
    private final ScheduledExecutorService scheduler;

    public void initialize() {
        if (this.settings.getStorage().getKeepResolvedReports() > 0 || this.settings.getStorage().getKeepRejectedReports() > 0) {
            this.scheduleCleanupTask();
        }
    }

    private void scheduleCleanupTask() {
        this.scheduler.scheduleAtFixedRate(this::cleanupOldReports, 1L, 24L, TimeUnit.HOURS);
    }

    private void cleanupOldReports() {
        int resolvedDays = this.settings.getStorage().getKeepResolvedReports();
        int rejectedDays = this.settings.getStorage().getKeepRejectedReports();
        if (resolvedDays > 0) {
            LocalDateTime resolvedCutoff = LocalDateTime.now().minus(resolvedDays, ChronoUnit.DAYS);
            List<Report> resolvedReports = this.databaseManager.getResolvedReportsBefore(resolvedCutoff);
            for (Report report : resolvedReports) {
                this.databaseManager.deleteReport(report.getId());
            }
        }
        if (rejectedDays > 0) {
            LocalDateTime rejectedCutoff = LocalDateTime.now().minus(rejectedDays, ChronoUnit.DAYS);
            List<Report> rejectedReports = this.databaseManager.getRejectedReportsBefore(rejectedCutoff);
            for (Report report : rejectedReports) {
                this.databaseManager.deleteReport(report.getId());
            }
        }
    }

    public StorageManager(Settings settings, DatabaseManager databaseManager, ScheduledExecutorService scheduler) {
        this.settings = settings;
        this.databaseManager = databaseManager;
        this.scheduler = scheduler;
    }
}

