/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.task;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinReports.reports.Report;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ReportCleanupTask
extends BukkitRunnable {
    private final BukkitPlugin plugin;

    public ReportCleanupTask(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void run() {
        ConfigurationSection autoCloseConfig = this.plugin.getConfig().getConfigurationSection("reports.status.auto_close");
        if (autoCloseConfig == null || !autoCloseConfig.getBoolean("enabled", true)) {
            return;
        }
        int resolvedDeleteAfter = autoCloseConfig.getInt("resolved_delete_after", 168);
        int rejectedDeleteAfter = autoCloseConfig.getInt("rejected_delete_after", 72);
        LocalDateTime resolvedThreshold = LocalDateTime.now().minus(resolvedDeleteAfter, ChronoUnit.HOURS);
        this.plugin.getDatabaseManager().deleteOldReports(Report.ReportStatus.RESOLVED, resolvedThreshold);
        LocalDateTime rejectedThreshold = LocalDateTime.now().minus(rejectedDeleteAfter, ChronoUnit.HOURS);
        this.plugin.getDatabaseManager().deleteOldReports(Report.ReportStatus.REJECTED, rejectedThreshold);
    }

    public void schedule() {
        this.runTaskTimerAsynchronously((Plugin)this.plugin, 72000L, 72000L);
    }
}

