/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
    private static ErrorHandler instance;
    private final Map<String, ErrorOccurrence> errorOccurrences = new ConcurrentHashMap<String, ErrorOccurrence>();
    private final Map<String, Long> errorSuppression = new ConcurrentHashMap<String, Long>();
    private int maxErrorRepetitions = 3;
    private long suppressionTimeMinutes = 10L;
    private boolean detailedLogging = true;
    private boolean logStackTraces = true;

    private ErrorHandler() {
    }

    public static synchronized ErrorHandler getInstance() {
        if (instance == null) {
            instance = new ErrorHandler();
        }
        return instance;
    }

    public void handleException(Throwable e, String source, Map<String, Object> context) {
        if (e == null) {
            return;
        }
        String errorSignature = this.generateErrorSignature(e, source);
        if (this.isErrorSuppressed(errorSignature)) {
            return;
        }
        String formattedMessage = this.formatErrorMessage(e, source, context);
        ErrorOccurrence occurrence = this.errorOccurrences.computeIfAbsent(errorSignature, k -> new ErrorOccurrence());
        ++occurrence.count;
        occurrence.lastOccurrence = System.currentTimeMillis();
        if (occurrence.count <= this.maxErrorRepetitions) {
            if (e instanceof RuntimeException || e instanceof Error) {
                logger.error(formattedMessage, e);
            } else {
                logger.warn(formattedMessage, e);
            }
        } else if (occurrence.count == this.maxErrorRepetitions + 1) {
            logger.warn("Suppressing further occurrences of error for {} minutes: {}", (Object)this.suppressionTimeMinutes, (Object)errorSignature);
            this.errorSuppression.put(errorSignature, System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(this.suppressionTimeMinutes));
        }
    }

    public void handleException(Throwable e, String source) {
        this.handleException(e, source, new HashMap<String, Object>());
    }

    private String formatErrorMessage(Throwable e, String source, Map<String, Object> context) {
        StringBuilder sb = new StringBuilder();
        sb.append("[AevorinReports] Error in component: ").append(source).append("\n");
        sb.append("Type: ").append(e.getClass().getName()).append("\n");
        sb.append("Message: ").append(e.getMessage()).append("\n");
        if (!context.isEmpty() && this.detailedLogging) {
            sb.append("Context:\n");
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                sb.append("  ").append(entry.getKey()).append(": ");
                if (entry.getValue() != null) {
                    sb.append(entry.getValue().toString());
                } else {
                    sb.append("null");
                }
                sb.append("\n");
            }
        }
        if (this.logStackTraces) {
            sb.append("Stack trace:\n").append(this.getStackTraceAsString(e));
        }
        return sb.toString();
    }

    private String getStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private String generateErrorSignature(Throwable e, String source) {
        return source + "-" + e.getClass().getName() + "-" + (e.getStackTrace().length > 0 ? e.getStackTrace()[0].toString() : "unknown");
    }

    private boolean isErrorSuppressed(String errorSignature) {
        Long suppressUntil = this.errorSuppression.get(errorSignature);
        if (suppressUntil != null) {
            if (System.currentTimeMillis() < suppressUntil) {
                return true;
            }
            this.errorSuppression.remove(errorSignature);
            this.errorOccurrences.remove(errorSignature);
        }
        return false;
    }

    public void installGlobalHandler() {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("thread", thread.getName());
            context.put("thread_id", thread.getId());
            this.handleException(throwable, "UncaughtExceptionHandler", context);
        });
        logger.info("Installed global exception handler");
    }

    public void configure(int maxRepetitions, long suppressionMinutes, boolean detailed, boolean stackTraces) {
        this.maxErrorRepetitions = maxRepetitions;
        this.suppressionTimeMinutes = suppressionMinutes;
        this.detailedLogging = detailed;
        this.logStackTraces = stackTraces;
    }

    private static class ErrorOccurrence {
        int count = 0;
        long lastOccurrence = 0L;

        private ErrorOccurrence() {
        }
    }
}

