/*
 * Decompiled with CFR 0.152.
 */
package dev.aevorinstudios.aevorinReports.utils;

import dev.aevorinstudios.aevorinReports.bukkit.BukkitPlugin;
import dev.aevorinstudios.aevorinreports.libs.gson.JsonArray;
import dev.aevorinstudios.aevorinreports.libs.gson.JsonObject;
import dev.aevorinstudios.aevorinreports.libs.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VersionChecker {
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2";
    private static final String PROJECT_ID = "OwqSnlXx";
    private static final String USER_AGENT = "AevorinReports/VersionChecker/1.0.3";
    private final BukkitPlugin plugin;
    private String latestVersion = null;

    public VersionChecker(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void startVersionChecking() {
        long checkInterval = 432000L;
        long initialDelay = 6000L;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.checkVersion().thenAccept(hasUpdate -> {
            if (hasUpdate.booleanValue()) {
                this.notifyOperators();
            }
        }), initialDelay, checkInterval);
    }

    private CompletableFuture<Boolean> checkVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/OwqSnlXx/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", USER_AGENT);
                if (connection.getResponseCode() != 200) {
                    this.plugin.getLogger().warning("Failed to check for updates. Response code: " + connection.getResponseCode());
                    return false;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    JsonArray versions = JsonParser.parseString(response.toString()).getAsJsonArray();
                    if (versions.size() <= 0) return false;
                    JsonObject latestVersion = versions.get(0).getAsJsonObject();
                    String newVersion = latestVersion.get("version_number").getAsString();
                    String currentVersion = this.plugin.getDescription().getVersion();
                    this.latestVersion = newVersion;
                    Boolean bl = this.compareVersions(currentVersion, newVersion) < 0;
                    return bl;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error checking for updates", e);
            }
            return false;
        });
    }

    private int compareVersions(String current, String latest) {
        String[] currentParts = current.split("\\.");
        String[] latestParts = latest.split("\\.");
        int length = Math.max(currentParts.length, latestParts.length);
        for (int i = 0; i < length; ++i) {
            int latestPart;
            int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
            if (currentPart < latestPart) {
                return -1;
            }
            if (currentPart <= latestPart) continue;
            return 1;
        }
        return 0;
    }

    private void notifyOperators() {
        String message = ChatColor.GREEN + "[AevorinReports] " + ChatColor.YELLOW + "A new version is available! " + ChatColor.WHITE + "Current version: " + ChatColor.RED + this.plugin.getDescription().getVersion() + ChatColor.WHITE + ", Latest version: " + ChatColor.GREEN + this.latestVersion + ChatColor.WHITE + ". Please update from Modrinth.";
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getLogger().info("A new version is available! Current version: " + this.plugin.getDescription().getVersion() + ", Latest version: " + this.latestVersion);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp() && !player.hasPermission("aevorinreports.update.notify")) continue;
                player.sendMessage(message);
            }
        });
    }
}

