/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyhammersandexcavators.event;

import com.blocklegend001.onlyhammersandexcavators.item.custom.Excavator;
import com.blocklegend001.onlyhammersandexcavators.item.custom.Hammer;
import com.blocklegend001.onlyhammersandexcavators.utils.RadiusMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="onlyhammersandexcavators", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEventsToolHandler {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onToolUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack mainHandItem = player.getMainHandItem();
        BlockPos origin = event.getPos();
        if (HARVESTED_BLOCKS.contains(origin)) {
            return;
        }
        HARVESTED_BLOCKS.add(origin);
        try {
            boolean isSneaking = player.isCrouching() || player.isShiftKeyDown();
            Item item = mainHandItem.getItem();
            if (item instanceof Hammer) {
                Hammer hammer = (Hammer)item;
                int radius = isSneaking ? 0 : RadiusMap.getHammerRadius().getOrDefault(mainHandItem.getItem(), 0);
                HashSet<BlockPos> blocksToBreak = new HashSet<BlockPos>(Hammer.getBlocksToBeDestroyed(radius, origin, serverPlayer));
                ModEventsToolHandler.processBlocks(blocksToBreak, origin, event, serverPlayer, mainHandItem, hammer);
            } else {
                item = mainHandItem.getItem();
                if (item instanceof Excavator) {
                    Excavator excavator = (Excavator)item;
                    int radius = isSneaking ? 0 : RadiusMap.getExcavatorRadius().getOrDefault(mainHandItem.getItem(), 0);
                    HashSet<BlockPos> blocksToBreak = new HashSet<BlockPos>(Excavator.getBlocksToBeDestroyed(radius, origin, serverPlayer));
                    ModEventsToolHandler.processBlocks(blocksToBreak, origin, event, serverPlayer, mainHandItem, excavator);
                }
            }
        }
        finally {
            HARVESTED_BLOCKS.remove(origin);
        }
    }

    private static <T> void processBlocks(Set<BlockPos> positions, BlockPos origin, BlockEvent.BreakEvent event, ServerPlayer player, ItemStack tool, T toolType) {
        if (positions == null) {
            return;
        }
        for (BlockPos pos : positions) {
            if (pos.equals((Object)origin) || HARVESTED_BLOCKS.contains(pos)) continue;
            boolean canHarvest = false;
            if (toolType instanceof Hammer) {
                Hammer hammer = (Hammer)((Object)toolType);
                canHarvest = hammer.isCorrectToolForDrops(tool, event.getLevel().getBlockState(pos));
            } else if (toolType instanceof Excavator) {
                Excavator excavator = (Excavator)((Object)toolType);
                canHarvest = excavator.isCorrectToolForDrops(tool, event.getLevel().getBlockState(pos));
            }
            if (!canHarvest) continue;
            HARVESTED_BLOCKS.add(pos);
            player.gameMode.destroyBlock(pos);
            HARVESTED_BLOCKS.remove(pos);
        }
    }
}

