/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyhammersandexcavators.item.custom;

import com.blocklegend001.onlyhammersandexcavators.utils.RadiusMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class Excavator
extends Item {
    private static TagKey<Block> shovelMineable;

    public Excavator(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties settings) {
        super(Excavator.computeSettings(material, (TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL, settings, attackDamage, attackSpeed));
    }

    private static Item.Properties computeSettings(ToolMaterial material, TagKey<Block> shovelMineable, Item.Properties settings, float attackDamage, float attackSpeed) {
        Excavator.shovelMineable = shovelMineable;
        settings.shovel(Excavator.wrapMaterial(material, material.durability()), attackDamage, attackSpeed);
        return settings;
    }

    public static List<BlockPos> getBlocksToBeDestroyed(int range, BlockPos initalBlockPos, ServerPlayer player) {
        int y;
        int x;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockHitResult traceResult = player.level().clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (traceResult.getType() == HitResult.Type.MISS) {
            return positions;
        }
        if (traceResult.getDirection() == Direction.DOWN || traceResult.getDirection() == Direction.UP) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY(), initalBlockPos.getZ() + y));
                }
            }
        }
        if (traceResult.getDirection() == Direction.NORTH || traceResult.getDirection() == Direction.SOUTH) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY() + y, initalBlockPos.getZ()));
                }
            }
        }
        if (traceResult.getDirection() == Direction.EAST || traceResult.getDirection() == Direction.WEST) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX(), initalBlockPos.getY() + y, initalBlockPos.getZ() + x));
                }
            }
        }
        return positions;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltip, Consumer<Component> consumer, TooltipFlag type) {
        int radius = this.getRadiusForExcavator(stack);
        int widht = radius * 2 + 1;
        MutableComponent text = Component.literal((String)"Dig area: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(widht + "x1")).withStyle(ChatFormatting.YELLOW));
        consumer.accept((Component)text);
        super.appendHoverText(stack, context, tooltip, consumer, type);
    }

    private int getRadiusForExcavator(ItemStack stack) {
        if (RadiusMap.getExcavatorRadius().containsKey(stack.getItem())) {
            return RadiusMap.getExcavatorRadius().get(stack.getItem());
        }
        return 0;
    }

    private static ToolMaterial wrapMaterial(ToolMaterial toolMaterial, int durability) {
        return new ToolMaterial(toolMaterial.incorrectBlocksForDrops(), durability, toolMaterial.speed(), toolMaterial.attackDamageBonus(), toolMaterial.enchantmentValue(), toolMaterial.repairItems());
    }
}

